/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import org.bushe.swing.event.EventService;

import presenter.Presenter;
import presenter.dto.LabelViewDto;

import com.google.inject.Inject;
import com.vaadin.ui.Button;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Button.ClickEvent;

@SuppressWarnings("serial")
public class ToolsPanel extends VerticalLayout implements Button.ClickListener {

	@SuppressWarnings("unused")
	private final EventService eventService;
	@SuppressWarnings("unused")
	private Presenter presenter;

	private final Panel panel;
	private final Table table;

	@Inject
	public ToolsPanel(EventService eventService) {

		this.eventService = eventService;

		this.panel = new Panel();
		this.table = new Table();

		init();
		setToolsData();

	}

	// @Override
	public void init() {
		setWidth("150px");
		setHeight("50%");
		setMargin(false, false, false, false);

		VerticalLayout wLayout = (VerticalLayout) panel.getContent();
		wLayout.setMargin(false, false, false, false);
		wLayout.setSizeFull();

		Label title = new Label("Tools");
		title.addStyleName(ThemeConstants.LABEL_H2);

		addComponent(title);

		panel.addStyleName(ThemeConstants.PANEL_LIGHT);

		table.setColumnHeaderMode(Table.COLUMN_HEADER_MODE_HIDDEN);
		table.setSizeFull();
		table.addStyleName(ThemeConstants.TABLE_BORDERLESS);

		table.addContainerProperty("Tools", Button.class, null);

		addComponent(panel);
		panel.addComponent(table);

	}

	// @Override
	public void setToolsData() {

		table.removeAllItems();

		Button manageLabels = new Button("Manage labels");
		manageLabels.setStyleName(ThemeConstants.BUTTON_LINK);
		manageLabels.addListener(this);
		table.addItem(new Object[] { manageLabels }, "manange_labels");

		Button addBookmark = new Button("Add bookmark");
		addBookmark.setStyleName(ThemeConstants.BUTTON_LINK);
		addBookmark.addListener(this);
		table.addItem(new Object[] { addBookmark }, "add_bookmark");

		Button deleteBookmark = new Button("Delete all bookmarks");
		deleteBookmark.setStyleName(ThemeConstants.BUTTON_LINK);
		deleteBookmark.addListener(this);
		table.addItem(new Object[] { deleteBookmark }, "delete_all_bookmarks");

	}

	/*
	 * Shows a notification when a button is clicked.
	 */
	public void buttonClick(ClickEvent event) {
		getWindow().showNotification(
				"link clicked: "
						+ ((LabelViewDto) event.getButton().getData())
								.getName());
	}
}
