/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import guice.BookMarkItemViewProvider;

import java.util.List;

import org.bushe.swing.event.EventService;

import presenter.BookmarkListChangeEvent;
import presenter.ChangeType;
import presenter.BookmarkItemPresenter.BookmarkItemView;
import presenter.BookmarkListPresenter.BookmarkListView;
import presenter.dto.BookmarkViewDto;

import com.google.inject.Inject;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Table;
import com.vaadin.ui.VerticalLayout;

@SuppressWarnings("serial")
public class BookmarkListPanel extends VerticalLayout implements
		BookmarkListView {

	private final EventService eventService;
	private final BookMarkItemViewProvider bookmarkItemViewProvider;

	private final Panel panel;
	private final Table table;

	@Inject
	public BookmarkListPanel(EventService eventService,
			BookMarkItemViewProvider bookmarkItemProvider) {

		this.eventService = eventService;
		this.bookmarkItemViewProvider = bookmarkItemProvider;

		this.panel = new Panel();
		this.table = new Table();

	}

	@Override
	public void init() {

		setSizeFull();
		setMargin(false, false, false, false);

		Label title = new Label("Bookmarks");
		title.addStyleName(ThemeConstants.LABEL_H2);
		addComponent(title);

		panel.setStyleName(ThemeConstants.PANEL_LIGHT);
		VerticalLayout wLayout = (VerticalLayout) panel.getContent();
		wLayout.setSizeFull();
		wLayout.setMargin(false, false, false, false);

		table.addStyleName(ThemeConstants.TABLE_BORDERLESS);
		table.setSizeFull();
		table.addStyleName(ThemeConstants.LAYOUT_WHITE);

		table.addContainerProperty("Bookmark", BookmarkItem.class, null);
		table.setColumnHeaderMode(Table.COLUMN_HEADER_MODE_HIDDEN);

		addComponent(panel);
		panel.addComponent(table);

		this.eventService.publish(new BookmarkListChangeEvent(null,
				ChangeType.INITIALIZE));

	}

	@Override
	public void setBookmarkData(List<BookmarkViewDto> bookmarkViewDtos) {

		for (BookmarkViewDto bookmarkViewDto : bookmarkViewDtos) {

			BookmarkItemView item = bookmarkItemViewProvider.get();

			item.update(bookmarkViewDto);

			table.addItem(new Object[] { item }, bookmarkViewDto.getId());

		}
	}
}
