/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import java.util.Arrays;

import org.bushe.swing.event.EventService;

import presenter.BookmarkItemChangeEvent;
import presenter.BookmarkItemPresenter.BookmarkItemFormView;
import presenter.ChangeType;
import presenter.dto.BookmarkViewDto;

import com.google.inject.Inject;
import com.vaadin.data.Item;
import com.vaadin.data.util.PropertysetItem;
import com.vaadin.ui.Button;
import com.vaadin.ui.Button.ClickEvent;
import com.vaadin.ui.Component;
import com.vaadin.ui.DefaultFieldFactory;
import com.vaadin.ui.Field;
import com.vaadin.ui.Form;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;

@SuppressWarnings("serial")
public class BookmarkItemForm extends VerticalLayout implements
		BookmarkItemFormView {

	private static final String COMMON_FIELD_WIDTH = "400px";

	private final EventService eventService;

	private BookmarkViewDto bookmarkViewDto;

	@Inject
	public BookmarkItemForm(EventService eventservice) {
		this.eventService = eventservice;

		this.setSizeFull();
	}

	@Override
	public void init() {
		// TODO Auto-generated method stub

	}

	@Override
	public void initData(BookmarkViewDto bookmarkViewDto) {

		this.bookmarkViewDto = bookmarkViewDto;

		// Create the Form
		final Form bookmarkForm = new Form();
		bookmarkForm.setWriteThrough(false); // we want explicit 'apply'
		bookmarkForm.setInvalidCommitted(false); // no invalid values in
													// datamodel

		// FieldFactory for customizing the fields
		bookmarkForm.setFormFieldFactory(new BookmarkFieldFactory());
		bookmarkForm.setItemDataSource((PropertysetItem) bookmarkViewDto);

		// Determines which properties are shown, and in which order:
		bookmarkForm.setVisibleItemProperties(Arrays.asList(new String[] {
				"title", "labels", "description" }));

		// Add form to layout
		addComponent(bookmarkForm);

		// The cancel / apply buttons
		HorizontalLayout buttons = new HorizontalLayout();
		buttons.setSpacing(true);

		Button save = new Button("Save", new Button.ClickListener() {
			public void buttonClick(ClickEvent event) {
				try {
					bookmarkForm.commit();
					eventService
							.publish(new BookmarkItemChangeEvent<BookmarkItemForm>(
									BookmarkItemForm.this.bookmarkViewDto,
									ChangeType.SAVE, BookmarkItemForm.this));
				} catch (Exception e) {
					// Ignored, we'll let the Form handle the errors
				}
			}
		});
		save.addStyleName(ThemeConstants.BUTTON_SMALL);
		buttons.addComponent(save);
		bookmarkForm.getFooter().addComponent(buttons);
		bookmarkForm.getFooter().setMargin(false, false, true, true);

		Button cancel = new Button("Cancel", new Button.ClickListener() {
			public void buttonClick(ClickEvent event) {
				bookmarkForm.discard();
				eventService
						.publish(new BookmarkItemChangeEvent<BookmarkItemForm>(
								BookmarkItemForm.this.bookmarkViewDto,
								ChangeType.CANCEL, BookmarkItemForm.this));
			}
		});

		cancel.addStyleName(ThemeConstants.BUTTON_SMALL);
		buttons.addComponent(cancel);

	}

	private class BookmarkFieldFactory extends DefaultFieldFactory {

		public BookmarkFieldFactory() {
		}

		@Override
		public Field createField(Item item, Object propertyId,
				Component uiContext) {
			Field field = super.createField(item, propertyId, uiContext);
			if ("title".equals(propertyId)) {
				TextField tf = (TextField) field;
				tf.setRequired(true);
				tf.setRequiredError("Please enter a title");
				tf.setWidth(COMMON_FIELD_WIDTH);
			} else if ("labels".equals(propertyId)) {
				TextField tf = (TextField) field;
				tf.setRequired(false);
				tf.setWidth(COMMON_FIELD_WIDTH);
			} else if ("description".equals(propertyId)) {
				TextField tf = (TextField) field;
				tf.setRequired(false);
				tf.setWidth(COMMON_FIELD_WIDTH);
			}
			return field;
		}
	}
}
