/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package vaadin;

import java.net.URI;

import org.bushe.swing.event.EventService;

import presenter.BookmarkItemChangeEvent;
import presenter.ChangeType;
import presenter.BookmarkItemPresenter.BookmarkItemFormView;
import presenter.BookmarkItemPresenter.BookmarkItemView;
import presenter.dto.BookmarkViewDto;
import presenter.dto.LabelViewDto;

import com.google.inject.Inject;
import com.vaadin.terminal.ExternalResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Link;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Button.ClickEvent;

@SuppressWarnings("serial")
public class BookmarkItem extends VerticalLayout implements BookmarkItemView,
		Button.ClickListener {

	private final EventService eventService;

	private BookmarkViewDto bookmarkViewDto;

	@Inject
	public BookmarkItem(EventService eventservice) {
		this.eventService = eventservice;
	}

	@Override
	public void init() {

	}

	@Override
	public void update(BookmarkViewDto bookmarkViewDto) {

		this.bookmarkViewDto = bookmarkViewDto;

		removeAllComponents();

		final String title = bookmarkViewDto.getTitle();
		final String uri = bookmarkViewDto.getUri();
		final Label seperatorLabel = new Label("&nbsp;-&nbsp;",
				Label.CONTENT_XHTML);

		final HorizontalLayout hLayout = new HorizontalLayout();
		final HorizontalLayout hLayoutLabels = new HorizontalLayout();

		setMargin(true, false, false, false);
		// addStyleName(ThemeConstants.LAYOUT_WHITE);

		hLayout.setSpacing(true);
		hLayoutLabels.setSpacing(true);

		addComponent(hLayout);
		addComponent(hLayoutLabels);

		Link link = new Link(title, new ExternalResource(uri));
		hLayout.addComponent(link);

		hLayout.addComponent(createHostnameLabel(uri));

		hLayout.addComponent(createEditButton());

		hLayout.addComponent(seperatorLabel);

		hLayout.addComponent(createDeleteButton());

		for (LabelViewDto labelViewDto : bookmarkViewDto.getLabels()) {
			hLayoutLabels.addComponent(createLabelButtons(labelViewDto));
		}

	}

	@Override
	public void buttonClick(ClickEvent event) {
		getWindow().showNotification(
				"link clicked: " + bookmarkViewDto.getTitle());
	}

	private Button createLabelButtons(LabelViewDto labelViewDto) {
		Button label = new Button(labelViewDto.getName());
		label.setStyleName(ThemeConstants.BUTTON_LINK);
		label.setData(labelViewDto);
		label.addListener(new Button.ClickListener() {

			@Override
			public void buttonClick(ClickEvent event) {
				getWindow().showNotification(
						"link clicked: "
								+ ((LabelViewDto) event.getButton().getData())
										.getName());
			}
		});
		return label;
	}

	private Button createDeleteButton() {
		Button deleteButton = new Button("Delete");
		deleteButton.setStyleName(ThemeConstants.BUTTON_LINK);
		deleteButton.addListener(new Button.ClickListener() {

			@Override
			public void buttonClick(ClickEvent event) {
				eventService
						.publish(new BookmarkItemChangeEvent<BookmarkItemView>(
								bookmarkViewDto, ChangeType.DELETE,
								BookmarkItem.this));
			}
		});
		return deleteButton;
	}

	private Button createEditButton() {
		Button editButton = new Button("Edit");
		editButton.setStyleName(ThemeConstants.BUTTON_LINK);
		editButton.addListener(new Button.ClickListener() {

			@Override
			public void buttonClick(ClickEvent event) {
				eventService
						.publish(new BookmarkItemChangeEvent<BookmarkItemView>(
								bookmarkViewDto, ChangeType.EDIT,
								BookmarkItem.this));
			}
		});
		return editButton;
	}

	private Label createHostnameLabel(final String uri) {
		return new Label("&nbsp;-&nbsp;" + getHostName(uri) + "&nbsp;-&nbsp;",
				Label.CONTENT_XHTML);
	}

	private String getHostName(String uri) {

		String uriTemp = "";
		try {
			uriTemp = new URI(uri).getHost();
		} catch (Exception e) {
		}

		return uriTemp;
	}

	@Override
	public void addForm(BookmarkItemFormView bookmarkItemViewForm) {

		removeAllComponents();

		addComponent((Component) bookmarkItemViewForm);
	}
}
