/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import model.ModelService;

public class ContextListener implements ServletContextListener {

	private ModelService modelService = null;

	public void contextInitialized(ServletContextEvent event) {

		String modelServiceClassName = event.getServletContext()
				.getInitParameter("modelService.factory");

		try {
			modelService = (ModelService) Class.forName(modelServiceClassName)
					.newInstance();
		} catch (final InstantiationException e) {
			throw new ClassFormatError();
		} catch (final IllegalAccessException e) {
			throw new ClassFormatError();
		} catch (final ClassNotFoundException e) {
			throw new ClassFormatError();
		}

		if (modelService != null) {
			event.getServletContext()
					.setAttribute("modelService", modelService);
		}
	}

	public void contextDestroyed(ServletContextEvent arg0) {
		if (modelService != null) {
			modelService.stop();
		}
	}
}
