/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter.dto;

import java.util.ArrayList;
import java.util.List;

import model.BookmarkDto;
import model.LabelDto;

import com.vaadin.data.util.ObjectProperty;
import com.vaadin.data.util.PropertysetItem;

@SuppressWarnings( { "serial" })
public class BookmarkItemAdapter extends PropertysetItem implements
		BookmarkViewDto {

	private final long id;
	private String title;
	private String uri;
	private String description;
	private List<LabelViewDto> labelViewDtos;

	private class TitleProperty extends ObjectProperty {

		public TitleProperty() {
			super(null, String.class);
		}

		@Override
		public Object getValue() {
			return toString();
		}

		@Override
		public void setValue(Object newValue) throws ReadOnlyException,
				ConversionException {

			if (newValue != null) {
				BookmarkItemAdapter.this.title = (String) newValue;
			}
		}

		@Override
		public String toString() {
			return BookmarkItemAdapter.this.title;
		}
	}

	class LabelsProperty extends ObjectProperty {

		public LabelsProperty() {
			super(null, String.class);
		}

		@Override
		public Object getValue() {
			return toString();
		}

		@Override
		public void setValue(Object newValue) throws ReadOnlyException,
				ConversionException {

			if (newValue != null) {
				final String value = (String) newValue;
				final List<LabelViewDto> labelViewDtos = new ArrayList<LabelViewDto>();

				for (String labelName : value.split(",")) {
					labelViewDtos.add(new LabelViewDtoImpl(labelName.trim()));
				}

				BookmarkItemAdapter.this.labelViewDtos = labelViewDtos;

			}
		}

		@Override
		public String toString() {
			return convertLabelListToString(BookmarkItemAdapter.this
					.getLabels());
		}

		private String convertLabelListToString(List<LabelViewDto> labelViewDtos) {
			StringBuffer strBuffer = new StringBuffer();

			for (LabelViewDto label : labelViewDtos) {
				strBuffer.append(label.getName()).append(',');
			}

			return strBuffer.toString().replaceFirst(",$", "");
		}

	}

	class DescriptionProperty extends ObjectProperty {

		public DescriptionProperty(BookmarkViewDto bookmarkViewDto) {
			super(null, String.class);
		}

		@Override
		public Object getValue() {
			return toString();
		}

		@Override
		public void setValue(Object newValue) throws ReadOnlyException,
				ConversionException {

			if (newValue != null) {
				BookmarkItemAdapter.this.description = (String) newValue;
			}
		}

		@Override
		public String toString() {
			return BookmarkItemAdapter.this.description;
		}
	}

	public BookmarkItemAdapter(final BookmarkDto bookmarkDto) {
		this.id = bookmarkDto.getId();
		this.title = bookmarkDto.getTitle();
		this.uri = bookmarkDto.getUri();
		this.description = bookmarkDto.getDescription();

		labelViewDtos = new ArrayList<LabelViewDto>();
		for (LabelDto labelDto : bookmarkDto.getLabels()) {
			labelViewDtos.add(new LabelViewDtoImpl(labelDto));
		}

		addItemProperty("title", new TitleProperty());
		addItemProperty("labels", new LabelsProperty());
		addItemProperty("description", new DescriptionProperty(this));
	}

	@Override
	public long getId() {
		return id;
	}

	@Override
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Override
	public String getUri() {
		return uri;
	}

	public void setUri(String uri) {
		this.uri = uri;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public List<LabelViewDto> getLabels() {
		return labelViewDtos;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setLabelViewDtos(List<LabelViewDto> labelViewDtos) {
		this.labelViewDtos = labelViewDtos;
	}

}
