/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import model.AuthService;
import model.LabelDto;
import model.ModelService;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.generics.TypeReference;

import presenter.dto.LabelViewDto;
import presenter.dto.LabelViewDtoImpl;

import com.google.inject.Inject;

public class LabelListPresenter extends
		PresenterImpl<LabelListPresenter.LabelListView> {

	public interface LabelListView extends View {
		void setLabelData(List<LabelViewDto> label);
	}

	private class ViewLabelListEventSubscriber implements
			EventSubscriber<LabelListChangeEvent> {

		@Override
		public void onEvent(LabelListChangeEvent event) {

			switch (event.getChangeType()) {
			case ADD:
				addLabel(event.getLabel());
				break;

			case DELETE:
				removeLabel(event.getLabel());
				break;

			default:
				initilizeLabels();
				break;
			}

		}

	}

	private class ModelEventSubscriber implements
			EventSubscriber<Collection<LabelDto>> {

		@Override
		public void onEvent(Collection<LabelDto> event) {
			updateData(event);
		}

	}

	private final ModelService modelService;
	private final AuthService authService;

	private final ModelEventSubscriber modelEventSubscriber;
	private final ViewLabelListEventSubscriber viewLabelListEventSubscriber;

	@Inject
	public LabelListPresenter(LabelListView view, ModelService modelService,
			AuthService authService, EventService eventService) {

		super(eventService, view);

		this.modelService = modelService;
		this.authService = authService;

		this.viewLabelListEventSubscriber = new ViewLabelListEventSubscriber();
		eventService.subscribe(LabelListChangeEvent.class,
				viewLabelListEventSubscriber);

		this.modelEventSubscriber = new ModelEventSubscriber();
		eventService.subscribe(new TypeReference<Collection<LabelDto>>() {
		}.getType(), modelEventSubscriber);

		view.init();
	}

	private void updateData(Collection<LabelDto> labels) {
		List<LabelViewDto> labelList = new ArrayList<LabelViewDto>();

		for (LabelDto label : labels) {
			labelList.add(new LabelViewDtoImpl(label));
		}

		view.setLabelData(labelList);
	}

	private void initilizeLabels() {
		modelService.getLabels(authService.getLoginUser());
	}

	private void removeLabel(String label) {
		// TODO Auto-generated method stub

	}

	private void addLabel(String label) {
		// TODO Auto-generated method stub

	}

}
