/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import model.AuthService;
import model.BookmarkDto;
import model.ModelService;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.generics.TypeReference;

import presenter.dto.BookmarkViewDto;
import presenter.dto.BookmarkItemAdapter;

import com.google.inject.Inject;

public class BookmarkListPresenter extends
		PresenterImpl<BookmarkListPresenter.BookmarkListView> {

	public interface BookmarkListView extends View {
		void setBookmarkData(List<BookmarkViewDto> bookmarks);
	}

	private class ViewBookmarkListEventSubscriber implements
			EventSubscriber<BookmarkListChangeEvent> {

		@Override
		public void onEvent(BookmarkListChangeEvent event) {

			switch (event.getChangeType()) {
			case ADD:
				addBookmark(event.getBookmarkViewDto());
				break;

			case DELETE:
				removeBookmark(event.getBookmarkViewDto());
				break;

			default:
				initilizeBookmarks();
				break;
			}

		}

	}

	private class ModelEventSubscriber implements
			EventSubscriber<Collection<BookmarkDto>> {

		@Override
		public void onEvent(Collection<BookmarkDto> event) {
			updateData(event);
		}

	}

	private final ModelService modelService;
	private final AuthService authService;

	private final ModelEventSubscriber modelEventSubscriber;
	private final ViewBookmarkListEventSubscriber viewBookmarkListEventSubscriber;

	@Inject
	public BookmarkListPresenter(BookmarkListView view,
			ModelService modelService, AuthService authService,
			EventService eventService) {

		super(eventService, view);

		this.modelService = modelService;
		this.authService = authService;

		this.viewBookmarkListEventSubscriber = new ViewBookmarkListEventSubscriber();
		eventService.subscribe(BookmarkListChangeEvent.class,
				viewBookmarkListEventSubscriber);

		this.modelEventSubscriber = new ModelEventSubscriber();
		eventService.subscribe(new TypeReference<Collection<BookmarkDto>>() {
		}.getType(), modelEventSubscriber);

		view.init();
	}

	private void updateData(Collection<BookmarkDto> bookmarks) {
		final List<BookmarkViewDto> bookmarkViewDtos = new ArrayList<BookmarkViewDto>();

		for (BookmarkDto bookmark : bookmarks) {
			bookmarkViewDtos.add(new BookmarkItemAdapter(bookmark));
		}

		view.setBookmarkData(bookmarkViewDtos);
	}

	private void initilizeBookmarks() {
		modelService.getBookmarks(authService.getLoginUser());
	}

	private void removeBookmark(BookmarkViewDto bookmarkViewDto) {
		// TODO Auto-generated method stub

	}

	private void addBookmark(BookmarkViewDto bookmarkViewDto) {
		// TODO Auto-generated method stub

	}

}
