/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package presenter;

import presenter.dto.BookmarkViewDto;

public class BookmarkItemChangeEvent<V extends View> {

	private final BookmarkViewDto bookmarkViewDto;
	private final ChangeType changeType;
	private final V to;

	public BookmarkItemChangeEvent(final BookmarkViewDto bookmarkViewDto,
			ChangeType changeType, V to) {
		this.bookmarkViewDto = bookmarkViewDto;
		this.changeType = changeType;
		this.to = to;
	}

	public BookmarkViewDto getBookmarkViewDto() {
		return bookmarkViewDto;
	}

	public ChangeType getChangeType() {
		return changeType;
	}

	public V getTo() {
		return this.to;
	}
}
