/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package model.neo4j;

import model.LabelDto;
import presenter.dto.LabelViewDto;

class LabelDtoImpl extends BaseDtoImpl implements LabelDto {

	private final String name;
	private final int count;

	public LabelDtoImpl(final String name, final int count) {
		super();
		this.name = name;
		this.count = count;
	}

	public LabelDtoImpl(final Label label) {
		super(((LabelImpl) label).getTheNode().getId());
		this.name = label.getName();
		this.count = 0;
	}

	public LabelDtoImpl(final LabelViewDto labelViewDto) {
		super(labelViewDto.getId());
		this.name = labelViewDto.getName();
		this.count = labelViewDto.getCount();
	}

	public LabelDtoImpl(final Label label, final User user) {
		super(((LabelImpl) label).getTheNode().getId());
		this.name = label.getName();
		this.count = label.getCount(user);
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public int getCount() {
		return count;
	}

}
