/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package guice;

import model.AuthService;
import model.ModelService;
import model.neo4j.Neo4jAuthServiceImpl;
import model.neo4j.Neo4jDatabaseService;
import model.neo4j.Neo4jModelService;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.ThreadSafeEventService;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;

public class MainTestModule extends AbstractModule {

	private final String dbPath;

	public MainTestModule(final String dbPath) {
		this.dbPath = dbPath;
	}

	@Override
	protected void configure() {

		final Neo4jModelService modelService = new Neo4jModelService(
				new Neo4jDatabaseService(dbPath));
		bind(ModelService.class).toInstance(modelService);

		bind(AuthService.class).to(Neo4jAuthServiceImpl.class).in(
				Singleton.class);

		Mockery context = new JUnit4Mockery();
		bind(Mockery.class).toInstance(context);

		bind(EventService.class).to(ThreadSafeEventService.class).in(
				Singleton.class);

	}
}
