/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package guice;

import javax.servlet.ServletContext;

import model.AuthService;
import model.ModelService;
import model.neo4j.Neo4jAuthServiceImpl;

import org.bushe.swing.event.EventService;
import org.bushe.swing.event.ThreadSafeEventService;

import presenter.BookmarkListPresenter;
import presenter.LabelListPresenter;
import presenter.BookmarkListPresenter.BookmarkListView;
import presenter.LabelListPresenter.LabelListView;
import vaadin.BookmarkListPanel;
import vaadin.LabelListPanel;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;

public class MainModule extends AbstractModule {

	private final ServletContext servletContext;

	public MainModule(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	@Override
	protected void configure() {
		bind(EventService.class).to(ThreadSafeEventService.class).in(
				Singleton.class);
		bind(LabelListView.class).to(LabelListPanel.class).in(Singleton.class);
		bind(BookmarkListView.class).to(BookmarkListPanel.class).in(
				Singleton.class);

		bind(LabelListPresenter.class).in(Singleton.class);
		bind(BookmarkListPresenter.class).in(Singleton.class);

		bind(BookMarkItemViewProvider.class).in(Singleton.class);
		bind(BookMarkItemFormProvider.class).in(Singleton.class);

		ModelService modelServiceInstance = (ModelService) servletContext
				.getAttribute("modelService");
		bind(ModelService.class).toInstance(modelServiceInstance);

		bind(AuthService.class).to(Neo4jAuthServiceImpl.class).in(
				Singleton.class);
	}
}
