/* ==========================================================================
 *
 * (c) 2010 Christoph Leisegang
 *
 * ========================================================================== */
package guice;

import model.AuthService;
import model.ModelService;

import org.bushe.swing.event.EventService;

import presenter.BookmarkItemPresenter;
import presenter.BookmarkItemPresenter.BookmarkItemView;
import vaadin.BookmarkItem;

import com.google.inject.Inject;
import com.google.inject.Provider;

public class BookMarkItemViewProvider implements Provider<BookmarkItemView> {

	private final ModelService modelService;
	private final AuthService authService;
	private final EventService eventService;
	private final BookMarkItemFormProvider bookmarkItemFormProvider;

	@Inject
	public BookMarkItemViewProvider(
			BookMarkItemFormProvider bookmarkItemFormProvider,
			ModelService modelService, AuthService authService,
			EventService eventService) {
		this.bookmarkItemFormProvider = bookmarkItemFormProvider;
		this.modelService = modelService;
		this.authService = authService;
		this.eventService = eventService;
	}

	@Override
	public BookmarkItemView get() {
		final BookmarkItemView bmarkItemView = new BookmarkItem(eventService);

		// attaches itself to the view
		new BookmarkItemPresenter(bmarkItemView, bookmarkItemFormProvider,
				modelService, authService, eventService);
		return bmarkItemView;
	}
}
