window.onload = init; //Events

var gl;  //WebGL-Context

var canvas;
var canvasWidth = -1;
var canvasHeight = -1;

function init() {
	//canvas so gross als mglich machen
    canvas    = document.getElementById("canvas");
    canvas.width  = Math.floor(window.innerWidth * 0.9);
    canvas.height = Math.floor(window.innerHeight * 0.9);
	
	//context erzeugen
    // ohne Debug: 
    //gl = canvas.getContext("experimental-webgl");
    gl = WebGLDebugUtils.makeDebugContext(canvas.getContext("experimental-webgl"));

    if (!gl) {
        alert("No WebGL context found");
    }
    
    //Shader erzeugen
    initShader(gl,"vshader","fshader");
    
    //Geometrie erzeugen
    initGeometry(gl);
    
    //Zeichnen
    setInterval(function() { draw() }, 10);
    //draw();
}


function initShader(gl,vShader,fShader){
	//Shader laden und kompilieren
	var vertexShader   = loadShader(gl,vShader);
	var fragmentShader = loadShader(gl,fShader);
	
	if (!vertexShader || !fragmentShader){
	    alert("No vertex or fragment shader");
            return false;
	}

	//Program Object erzeugen
	gl.program = gl.createProgram();
	
	if (!gl.program){
	    alert("No program object");
            return false;
	}

    gl.attachShader (gl.program, vertexShader);
    gl.attachShader (gl.program, fragmentShader);

	//Variablen binden
	gl.bindAttribLocation(gl.program,0,"vPosition");
    gl.bindAttribLocation(gl.program,1,"vNormal");
    gl.bindAttribLocation(gl.program,2,"vTexCoord");
	
	//Programm linken
	gl.linkProgram(gl.program);
	
    var linked = gl.getProgramParameter(gl.program, gl.LINK_STATUS);
    if (!linked) {
        var error = gl.getProgramInfoLog (gl.program);
	alert("link error");
        gl.deleteProgram(gl.program);
        return false;
    }

    gl.useProgram(gl.program);

    gl.clearColor(0.0, 0.0, 1.0, 1.0);
    gl.clearDepth(10000);

    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.BLEND);
    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    gl.disable(gl.CULL_FACE);
	
	return true;
}

function loadShader(gl,shaderName){
	//Shader-String suchen
	var shaderString = document.getElementById(shaderName);
    if (!shaderString) {
        alert("Error: shader script '"+shaderName+"' not found");
        return null;
    }
        
    if (shaderString.type == "x-shader/x-vertex")
        var shaderType = gl.VERTEX_SHADER;
    else if (shaderString.type == "x-shader/x-fragment")
        var shaderType = gl.FRAGMENT_SHADER;
    else {
        alert("Error: shader script '"+shaderName+"' of undefined type '"+shaderScript.type+"'");       
        return null;
    }
    
    //Shader Objekt erzeugen
    var shader = gl.createShader(shaderType);
    if (shader == null) {
        alert("Error: unable to create shader '"+shaderName+"'");       
        return null;
    }

	//Shader Source laden
	gl.shaderSource(shader, shaderString.text);
	
	//Shader kompilieren
	gl.compileShader(shader);
	
	var compiled = gl.getShaderParameter(shader, gl.COMPILE_STATUS);
    if (!compiled) {
        var error = gl.getShaderInfoLog(shader);
        alert(" Error compiling shader '"+shaderName+"':"+error);
        gl.deleteShader(shader);
        return null;
    }

    return shader;
}


var vertices;
var ixTexture;

function initGeometry(gl){
        //Alle konstanten Uniform Variablen fr Shader festlegen
        gl.uniform3f(gl.getUniformLocation(gl.program, "u_lightDir"), 0, 0, 1);
        gl.uniform1i(gl.getUniformLocation(gl.program, "u_sampler2d"), 0);
        
        
        //Texture einschalten
        //gl.enable(gl.TEXTURE_2D);
        
        // Erzeutgt einen Wrfel. gl wird um Attribut cube erweitert
        gl.cube = createColorCube(gl);

        // Create some matrices to use later and save their locations in the shaders
        gl.mvMatrix = new J3DIMatrix4();
        gl.u_normalMatrixLoc = gl.getUniformLocation(gl.program, "u_normalMatrix");
        gl.normalMatrix = new J3DIMatrix4();
        gl.u_modelViewProjMatrixLoc =
                gl.getUniformLocation(gl.program, "u_modelViewProjMatrix");
        gl.mvpMatrix = new J3DIMatrix4();

        // Enable all of the vertex attribute arrays.
        gl.enableVertexAttribArray(0);
        gl.enableVertexAttribArray(1);
        gl.enableVertexAttribArray(2);

        // VertexArrays: Vertex, Normal und Texture
        gl.bindBuffer(gl.ARRAY_BUFFER, gl.cube.vertexObject);
        gl.vertexAttribPointer(0, 3, gl.FLOAT, false, 0, 0);

        gl.bindBuffer(gl.ARRAY_BUFFER, gl.cube.normalObject);
        gl.vertexAttribPointer(1, 3, gl.FLOAT, false, 0, 0);

        gl.bindBuffer(gl.ARRAY_BUFFER, gl.cube.texCoordObject);
        gl.vertexAttribPointer(2, 2, gl.FLOAT, false, 0, 0);

        //Indexarray
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, gl.cube.indexObject);
        
        //Texture laden
        loadTexture(gl,"ix_logo_cube.jpg");
 
        return gl;

}


// Die Texture ldt der Browser ber den standardmigen 
// integrierten Bildlademechanismus. Wenn der Download komplett ist,
// startet der onload event handler und erzeugt aus dem Bild eine
// WebGLTexture.
function loadTexture(gl,url){
    gl.enable(gl.TEXTURE_2D);
    ixTexture = gl.createTexture();
    
    // DOM Image Objekt erzeugen
    var image = new Image();
    // Sobald der Browser das Bild geladen hat, fhrt er die
    // onload Funktion aus
    image.onload = function() {
        // Da diese Funkion irgendwann in der Zukunft luft, ist es
        // sicherer bindTexture erneut auszufhren
        gl.bindTexture(gl.TEXTURE_2D, ixTexture);
       //alt: gl.texImage2D(gl.TEXTURE_2D, 0, image);
        gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE,
                      image);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.CLAMP_TO_EDGE);
        gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.CLAMP_TO_EDGE);
        draw();
    };
    // Startet den Download des Bildes
    image.src = url;
}

// 
// createColorCube
//
// Erzeugt die Vertizes, Normalvektoren und Farben fr einen Wrfel. IndexArray und VertexBufferObjekte wird mit angelegt.
// Gibt eine Objet mit folgenden Eigenschaften zurck:
//
//  normalObject        WebGLBuffer Objekt mit Normalvektoren
//  texCoordObject      WebGLBuffer Objekt mit Texture-Koordinaten
//  vertexObject        WebGLBuffer Objekt mit Position
//  indexObject         WebGLBuffer Objekt mit Indizes
//  numIndices          Anzahl der Indizes
// 
function createColorCube(ctx)
{
    // Wrfel
    //    v6----- v5
    //   /|      /|
    //  v1------v0|
    //  | |     | |
    //  | |v7---|-|v4
    //  |/      |/
    //  v2------v3
    //
    // Position : Vertexarray
    // vertex coords array
    var vertices = new Float32Array(
        [  1, 1, 1,  -1, 1, 1,  -1,-1, 1,   1,-1, 1,    // v0-v1-v2-v3 front
           1, 1, 1,   1,-1, 1,   1,-1,-1,   1, 1,-1,    // v0-v3-v4-v5 right
           1, 1, 1,   1, 1,-1,  -1, 1,-1,  -1, 1, 1,    // v0-v5-v6-v1 top
          -1, 1, 1,  -1, 1,-1,  -1,-1,-1,  -1,-1, 1,    // v1-v6-v7-v2 left
          -1,-1,-1,   1,-1,-1,   1,-1, 1,  -1,-1, 1,    // v7-v4-v3-v2 bottom
           1,-1,-1,  -1,-1,-1,  -1, 1,-1,   1, 1,-1 ]   // v4-v7-v6-v5 back
    );

    // normal array
    var normals = new Float32Array(
        [  0, 0, 1,   0, 0, 1,   0, 0, 1,   0, 0, 1,     // v0-v1-v2-v3 front
           1, 0, 0,   1, 0, 0,   1, 0, 0,   1, 0, 0,     // v0-v3-v4-v5 right
           0, 1, 0,   0, 1, 0,   0, 1, 0,   0, 1, 0,     // v0-v5-v6-v1 top
          -1, 0, 0,  -1, 0, 0,  -1, 0, 0,  -1, 0, 0,     // v1-v6-v7-v2 left
           0,-1, 0,   0,-1, 0,   0,-1, 0,   0,-1, 0,     // v7-v4-v3-v2 bottom
           0, 0,-1,   0, 0,-1,   0, 0,-1,   0, 0,-1 ]    // v4-v7-v6-v5 back
       );


    // texCoord array
    var texCoords = new Float32Array(
        [  1, 1,   0, 1,   0, 0,   1, 0,    // v0-v1-v2-v3 front
           0, 1,   0, 0,   1, 0,   1, 1,    // v0-v3-v4-v5 right
           1, 0,   1, 1,   0, 1,   0, 0,    // v0-v5-v6-v1 top
           1, 1,   0, 1,   0, 0,   1, 0,    // v1-v6-v7-v2 left
           0, 0,   1, 0,   1, 1,   0, 1,    // v7-v4-v3-v2 bottom
           0, 0,   1, 0,   1, 1,   0, 1 ]   // v4-v7-v6-v5 back
       );

    // index array
    var indices = new Uint8Array(
        [  0, 1, 2,   0, 2, 3,    // front
           4, 5, 6,   4, 6, 7,    // right
           8, 9,10,   8,10,11,    // top
          12,13,14,  12,14,15,    // left
          16,17,18,  16,18,19,    // bottom
          20,21,22,  20,22,23 ]   // back
      );

    var result = { };
    
    result.normalObject = ctx.createBuffer();
    ctx.bindBuffer(ctx.ARRAY_BUFFER, result.normalObject);
    ctx.bufferData(ctx.ARRAY_BUFFER, normals, ctx.STATIC_DRAW);
    
    result.texCoordObject = ctx.createBuffer();
    ctx.bindBuffer(ctx.ARRAY_BUFFER, result.texCoordObject);
    ctx.bufferData(ctx.ARRAY_BUFFER, texCoords, ctx.STATIC_DRAW);

    result.vertexObject = ctx.createBuffer();
    ctx.bindBuffer(ctx.ARRAY_BUFFER, result.vertexObject);
    ctx.bufferData(ctx.ARRAY_BUFFER, vertices, ctx.STATIC_DRAW);
    
    ctx.bindBuffer(ctx.ARRAY_BUFFER, null);

    result.indexObject = ctx.createBuffer();
    ctx.bindBuffer(ctx.ELEMENT_ARRAY_BUFFER, result.indexObject);
    ctx.bufferData(ctx.ELEMENT_ARRAY_BUFFER, indices, ctx.STATIC_DRAW);
    ctx.bindBuffer(ctx.ELEMENT_ARRAY_BUFFER, null);
    
    result.numIndices = indices.length;

    return result;
}


function reshape() {
	//Hat sich die Gre des Fensters gendert?
	if (canvas.width == canvasWidth && canvas.height == canvasHeight)
    	return;

    canvasWidth = canvas.width;
    canvasHeight = canvas.height;

    // Viewport und Projektionsmatrix festlegen
    gl.viewport(0, 0, canvasWidth, canvasHeight);
    gl.perspectiveMatrix = new J3DIMatrix4();
    gl.perspectiveMatrix.perspective(30, canvasWidth/canvasHeight, 1, 10000);
    gl.perspectiveMatrix.lookat(0, 0, 7, 0, 0, 0, 0, 1, 0);
    }
    
var currentAngle = 64;

function draw() {
    
    reshape();
    
    //Canvas lschen
    gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

	// Make a model/view matrix.
       
        gl.mvMatrix.makeIdentity();
        gl.mvMatrix.rotate(20, 1,0,0);
        gl.mvMatrix.rotate(currentAngle, 0,1,0);

        // Construct the normal matrix from the model-view matrix and pass it in
        gl.normalMatrix.load(gl.mvMatrix);
        gl.normalMatrix.invert();
        gl.normalMatrix.transpose();
        gl.normalMatrix.setUniform(gl,gl.u_normalMatrixLoc, false);

        // Construct the model-view * projection matrix and pass it in
        gl.mvpMatrix.load(gl.perspectiveMatrix);
        gl.mvpMatrix.multiply(gl.mvMatrix);
        gl.mvpMatrix.setUniform(gl,gl.u_modelViewProjMatrixLoc, false);
        
        //Textur binden
        gl.bindTexture(gl.TEXTURE_2D, ixTexture);

        //Ausgeben
        gl.drawElements(gl.TRIANGLES, gl.cube.numIndices, gl.UNSIGNED_BYTE, 0);
    gl.flush();
    
        currentAngle += 4;
        if (currentAngle > 360)
            currentAngle -= 360;

   // alert("Drawn");
}