REM  *****  BASIC  *****
'/** DatenpilotAktualisieren
'*************************************************************************.
'* @kurztext Aktualisiert alle Datenpiloten
'* Diese Funktion aktualisiert alle Datenpiloten des aktuellen Dokumentes.
'* Dabei wird fr jede Tabelle erprft, ob diese Datenpiloten enthlt, dann 
'* werden zunchst die Quellbereiche neu einlesen und somit werden eventuell hinzu-
'* gekommende Daten mit bercksichtigt und anschlieend wird der Datenpilot aktualisiert.
'* 
'*************************************************************************
'*/
Sub DatenpilotAktualisieren
    dim oDoc as variant    'das aktuelle Diument
    dim oSheets as variant  'alle Tabellen
    dim oSheet as variant   'eine Tabelle
    dim oDataPilot as variant   'ein Datenpilot
    dim oQuellDaten as variant  'Address-Range Objekt der Quelldaten
    dim oQuellTab as variant    'Tabelle der Quelldaten
    dim oDatCur as variant     'Cursorobjekt
    dim oEnde as variant       'Address-Range Objekt der letzten Zelle des neuen Bereiches
    dim i%, j%
    
	odoc = thisComponent
	oSheets = oDoc.getSheets()
	'Check, ob die Tabelle einen Datenpilot besitzt
	for i = 0 to oSheets.getCount() - 1
      oSheet = oSheets.getbyIndex(i)  'ein einzelnes Tabellenblatt
	  if oSheet.getDataPilotTables.count > 0 then   'mindestens ein Datenpilot ist vorhanden
	    'jetzt fr alle DataPilotTables
	    for j = 0 to oSheet.getDataPilotTables.count -1  
	      oDataPilot = oSheet.getDataPilotTables().getByIndex(j)  'Eine Datenpilottabelle
	      oQuellDaten = oDataPilot.SourceRange   'Auslesen des Quelldatenbereichs
	      oQuellTab = odoc.sheets.getByIndex(oQuelldaten.sheet)  'Quelldatentabelle
	      'Tabellenbereichscursor erzeugen - obere linke Ecke des Quellbereichs
	      oDatCur = oQuellTab.createCursorByRange(oQuelltab.getCellByPosition( _
	                      oQuellDaten.StartColumn, oQuellDaten.StartRow))
	      oDatCur.gotoEndofUsedArea(false)   'nach unten rechts gehen
	      oEnde = oDatCur.RangeAddress        'Adresse der letzen Zelle (unten rechts)
	      oQuellDaten.EndRow = oEnde.endRow  'letzte Zeile zuordnen
	      oQuellDaten.endColumn = oEnde.endColumn   'letzte Spate zuordnen
	      oDataPilot.SourceRange = oQuellDaten   'Quelldatenbereich zurckschreiben
	      oDataPilot.refresh()                  'Datenpilot aktualisieren
	      REM jetzt noch Datum der Aktualisierung in Zelle D1 der Tabele schreiben:
	      oSheet.getCellRangeByName("D1").value = now()
	    next j
	  end if
	next i
End Sub
