class TrainspotsController < ApplicationController
  
  before_filter :find_trainspot, :only => [:edit, :update, :show, :destroy]

  def index
    @trainspots = Trainspot.find :all
  end

  def new
    @trainspot = Trainspot.new
  end

  def create
    @trainspot = Trainspot.new(params[:trainspot])
    if @trainspot.save
      flash[:notice] = "Zugsichtung wurde gespeichert."
      redirect_to trainspots_path
    else
      render :action => :new
    end 
  end

  def update
    if @trainspot.update_attributes(params[:trainspot])
      flash[:notice] = "Zugsichtung wurde aktualisiert."
      redirect_to trainspots_path
    else
      render :action => :edit
    end  
  end

  def destroy
    @trainspot.destroy
    
    flash[:notice] = "Zugsichtung wurde entfernt."
    redirect_to trainspots_path
  end  
  
  private
  def find_trainspot
    @trainspot = Trainspot.find(params[:id])
  end
  
end
