class TrainspotsController < ApplicationController
  
  before_filter :authenticate, :except => [:show]
  before_filter :find_trainspot, :only => [:edit, :update, :destroy]

  def index
    @trainspots = @current_user.trainspots.find :all
  end

  def new
    @trainspot = Trainspot.new
  end

  def create
    @trainspot = @current_user.trainspots.build(params[:trainspot])
    if @trainspot.save
      flash[:notice] = "Zugsichtung wurde gespeichert."
      redirect_to trainspots_path
    else
      render :action => :new
    end 
  end

  def update
    if @trainspot.update_attributes(params[:trainspot])
      flash[:notice] = "Zugsichtung wurde aktualisiert."
      redirect_to trainspots_path
    else
      render :action => :edit
    end  
  end

  def destroy
    @trainspot.destroy
    
    flash[:notice] = "Zugsichtung wurde entfernt."
    redirect_to trainspots_path
  end  
  
  def show
    @trainspot = Trainspot.find params[:id]
    
    @map = GMap.new("map_div_id")  
    @map.control_init(:large_map => true, :map_type => true)  
    @map.center_zoom_init([@trainspot.lat, @trainspot.lng], 15)  

    marker = GMarker.new([@trainspot.lat, @trainspot.lng], :title => @trainspot.train, :info_window => @trainspot.notes)  
    @map.overlay_init(marker)
  end
    
  private
  def find_trainspot
    @trainspot = @current_user.trainspots.find params[:id]
  end
  
end
