# Filters added to this controller apply to all controllers in the application.
# Likewise, all the methods added will be available for all controllers.

class ApplicationController < ActionController::Base
  helper :all # include all helpers, all the time

  # See ActionController::RequestForgeryProtection for details
  # Uncomment the :secret if you're not using the cookie session store
  protect_from_forgery # :secret => 'b63b9b6c1a77f3af35e04ef04feabb65'
  
  protected
  def authenticate
    authenticate_or_request_with_http_basic do |login, password|
      @current_user = User.authenticate(login, password)
    end
  end  
  
end
