/********************************************************************
 * $Id: ILibraryService.java 81 2009-10-04 14:08:03Z rvandenh $
 *
 * (c) Copyright 2009 TH Wildau
 * All rights reserved
 ********************************************************************/
package de.thwildau.tm.library.api;

import java.util.List;
 

/**
 * Interface the library service
 * @author Ralf Vandenhouten
 * @version $Revision: 81 $
 */
public interface ILibraryService {
    /**
     * Get a list of all books in the library
     * @return the list of books
     */
    public List<Book> getBookList();
    /**
     * Get a list of all books in the library,
     * sorted by authors
     * @return the sorted 
     */
    public List<Book> getSortedBookList();
    /**
     * Get a list of all books that the given user has borrowed
     * @param userId - the ID of the user
     * @return the list of books lent to the user with the given ID
     */
    public List<Book> getBookList(long userId);
    /**
     * Check if the specified book is available for lending
     * @param bookId - the ID of the book to be checked
     * @return <code>true</code> if the book is available, 
     *         otherwise <code>false</code>
     */
    public boolean isAvailable(long bookId);
    /**
     * This method is called when a book is borrowed from the library.
     * The book is unavailable for others after this call.
     * @param userId - the ID of the user that wants to lend the book
     * @param bookId - the ID of the book
     * @return <code>true</code> if the lending process was successful,
     *         otherwise <code>false</code>
     */
    public boolean lendBook(long userId, long bookId);
    /**
     * This method is called when a user returns a book to the library.
     * The book is available again after this call.
     * @param bookId - the ID of the book
     */
    public void returnBook(long bookId);
}
