﻿<%@ WebHandler Language="C#" Class="DownloadHandler" %>

using System;
using System.Web;

public class DownloadHandler : IHttpHandler
{
    public void ProcessRequest(HttpContext context)
    {
        string Dateiname = context.Request.QueryString["Datei"];
        // Zusammenstellen des Pfades
        string Pfad = context.Server.MapPath("App_Data/Dateien/" + Dateiname);
        // Ermitteln der Länge
        System.IO.FileInfo file = new System.IO.FileInfo(Pfad);
        // Setzen der Header-Daten
        context.Response.ContentType = "binary/octet-stream";
        context.Response.AddHeader("Content-Type", "binary/octet-stream");
        context.Response.AddHeader("Content-Length", file.Length.ToString());
        context.Response.AddHeader("Content-Disposition", "attachment; filename=" + Dateiname + "; size=" + file.Length.ToString());
        // Schreiben der Datei
        context.Response.WriteFile(Pfad);
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }
}