﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.ComponentModel.DataAnnotations;


namespace DownloadModel
{
    // Partielle Klasse zur generierten Entitätsklasse
    [MetadataType(typeof(DA_DownloadAngebot_MetaData))]
    public partial class DA_DownloadAngebot
    {
        partial void OnDA_DatumEndeChanging(DateTime? value)
        {
            if (value < DateTime.Now) throw new ApplicationException("Endedatum muss in der Zukunft liegen!");
        }
    }
    
    // Metadatenklasse zur Entitätsklasse
    public partial class DA_DownloadAngebot_MetaData
    {
        [StringLength(200)]
        public string DA_Titel;

        [StringLength(1000)]
        public string DA_Text;

        [UIHint("Key")]
        public string DA_ID;

        [DisplayFormat(DataFormatString = "{0:d}", ApplyFormatInEditMode = true)]
        public DateTime DA_DatumStart;

        [DataType(DataType.Date)] // Alternativlösung
        public DateTime DA_DatumEnde;
    }

    // Partielle Klasse zur generierten Entitätsklasse
    [MetadataType(typeof(DD_DownloadDatei_MetaData))]
    public partial class DD_DownloadDatei
    {
    }

    // Metadatenklasse zur Entitätsklasse
    public partial class DD_DownloadDatei_MetaData
    {
        [Range(0,Int32.MaxValue)]
        public string DD_AnzahlDownloads;

        [UIHint("File")]
        public string DD_Dateiname;
    }
}