﻿using System;
using System.Linq;

public partial class _Default : System.Web.UI.Page
{
    string Suchtext = "";
    int Kategorie = -1;

    protected void C_Filtern_Click(object sender, EventArgs e)
    {
        if (this.C_Kategorie.SelectedValue != "Alle")
            Kategorie = Convert.ToInt32(this.C_Kategorie.SelectedValue);
        if (this.C_Suchtext.Text != "")
            Suchtext = this.C_Suchtext.Text;
    }

    protected void Page_PreRender(object sender, EventArgs e)
    {
        // Modell instanziieren
        DownloadModel.DownloadEntities model = new DownloadModel.DownloadEntities();
        // Grundgerüst der LINQ-Abfrage
        var Abfrage = from a in model.DA_DownloadAngebot.Include("DG_DownloadKategorie") where (a.DA_DatumStart <= DateTime.Now || a.DA_DatumStart == null) && (a.DA_DatumEnde >= DateTime.Now || a.DA_DatumEnde == null) select a;
        // Zusatz für Filtern?
        if (Kategorie >= 0)
            Abfrage = from a in Abfrage where a.DG_DownloadKategorie.DK_ID == Kategorie select a;
        // Zusatz für Suchen?
        if (Suchtext != "")
            Abfrage = from a in Abfrage where a.DA_Text.Contains(Suchtext) || a.DA_Titel.Contains(Suchtext) select a;
        // Binden der Daten
        this.C_Angebote.DataSource = Abfrage;
        this.C_Angebote.DataBind();
    }
}
