package nz.co.ventego.cghelloworld.command
{
	import com.adobe.cairngorm.commands.Command;
	import com.adobe.cairngorm.control.CairngormEvent;
	
	import mx.rpc.IResponder;
	
	import nz.co.ventego.cghelloworld.business.SendMessageDelegate;
	import nz.co.ventego.cghelloworld.model.HelloWorldModelLocator;
	import nz.co.ventego.cghelloworld.event.UserInputEvent;

	public class SendMessageCommand implements Command, IResponder
	{
		private var model:HelloWorldModelLocator = HelloWorldModelLocator.getInstance();

		public function execute(cgEvent:CairngormEvent):void 
		{
			var userInputEvent:UserInputEvent = UserInputEvent(cgEvent);
			var payloadData:String = userInputEvent.userInput.payloadData
			
			model.ausgabeLabelText = payloadData;
			
			// Delegate - der HTTPService liefert aus Gruenden der einfachen Kompilierbarkeit nur "Hello World" zurueck
			// Ein echter (nicht-XML) Service koennte hier beispielsweise einen Echo-Roundtrip zum Server durchfuehren
			
			// var delegate:SendMessageDelegate = new SendMessageDelegate(this);
			// delegate.sendMessage(payloadData);
		}
		
		public function result(rpcEvent:Object):void 
		{
			// model.ausgabeLabelText = rpcEvent.result.dummyData.dataset.value1;
		}
		
		public function fault(rpcEvent:Object):void 
		{
		}
	}
}
