import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class loeweRef implements ORAData, ORADataFactory
{
  public static final String _SQL_BASETYPE = "OBJECT.LOEWE";
  public static final int _SQL_TYPECODE = OracleTypes.REF;

  REF _ref;

private static final loeweRef _loeweRefFactory = new loeweRef();

  public static ORADataFactory getORADataFactory()
  { return _loeweRefFactory; }
  /* constructor */
  public loeweRef()
  {
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _ref;
  }

  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    loeweRef r = new loeweRef();
    r._ref = (REF) d;
    return r;
  }

  public static loeweRef cast(ORAData o) throws SQLException
  {
     if (o == null) return null;
     try { return (loeweRef) getORADataFactory().create(o.toDatum(null), OracleTypes.REF); }
     catch (Exception exn)
     { throw new SQLException("Unable to convert "+o.getClass().getName()+" to loeweRef: "+exn.toString()); }
  }

  public loewe getValue() throws SQLException
  {
     return (loewe) loewe.getORADataFactory().create(
       _ref.getSTRUCT(), OracleTypes.REF);
  }

  public void setValue(loewe c) throws SQLException
  {
    _ref.setValue((STRUCT) c.toDatum(_ref.getJavaSqlConnection()));
  }
}
