import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class elsterRef implements ORAData, ORADataFactory
{
  public static final String _SQL_BASETYPE = "OBJECT.ELSTER";
  public static final int _SQL_TYPECODE = OracleTypes.REF;

  REF _ref;

private static final elsterRef _elsterRefFactory = new elsterRef();

  public static ORADataFactory getORADataFactory()
  { return _elsterRefFactory; }
  /* constructor */
  public elsterRef()
  {
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _ref;
  }

  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    elsterRef r = new elsterRef();
    r._ref = (REF) d;
    return r;
  }

  public static elsterRef cast(ORAData o) throws SQLException
  {
     if (o == null) return null;
     try { return (elsterRef) getORADataFactory().create(o.toDatum(null), OracleTypes.REF); }
     catch (Exception exn)
     { throw new SQLException("Unable to convert "+o.getClass().getName()+" to elsterRef: "+exn.toString()); }
  }

  public elster getValue() throws SQLException
  {
     return (elster) elster.getORADataFactory().create(
       _ref.getSTRUCT(), OracleTypes.REF);
  }

  public void setValue(elster c) throws SQLException
  {
    _ref.setValue((STRUCT) c.toDatum(_ref.getJavaSqlConnection()));
  }
}
