import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class TierRef implements ORAData, ORADataFactory
{
  public static final String _SQL_BASETYPE = "OBJECT.TIER";
  public static final int _SQL_TYPECODE = OracleTypes.REF;

  REF _ref;

private static final TierRef _TierRefFactory = new TierRef();

  public static ORADataFactory getORADataFactory()
  { return _TierRefFactory; }
  /* constructor */
  public TierRef()
  {
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _ref;
  }

  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    TierRef r = new TierRef();
    r._ref = (REF) d;
    return r;
  }

  public static TierRef cast(ORAData o) throws SQLException
  {
     if (o == null) return null;
     try { return (TierRef) getORADataFactory().create(o.toDatum(null), OracleTypes.REF); }
     catch (Exception exn)
     { throw new SQLException("Unable to convert "+o.getClass().getName()+" to TierRef: "+exn.toString()); }
  }

  public Tier getValue() throws SQLException
  {
     return (Tier) Tier.getORADataFactory().create(
       _ref.getSTRUCT(), OracleTypes.REF);
  }

  public void setValue(Tier c) throws SQLException
  {
    _ref.setValue((STRUCT) c.toDatum(_ref.getJavaSqlConnection()));
  }
}
