import java.sql.SQLException;
import java.sql.Connection;
import oracle.jdbc.OracleTypes;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.STRUCT;

public class SaeugetierRef implements ORAData, ORADataFactory
{
  public static final String _SQL_BASETYPE = "OBJECT.SAEUGETIER";
  public static final int _SQL_TYPECODE = OracleTypes.REF;

  REF _ref;

private static final SaeugetierRef _SaeugetierRefFactory = new SaeugetierRef();

  public static ORADataFactory getORADataFactory()
  { return _SaeugetierRefFactory; }
  /* constructor */
  public SaeugetierRef()
  {
  }

  /* ORAData interface */
  public Datum toDatum(Connection c) throws SQLException
  {
    return _ref;
  }

  /* ORADataFactory interface */
  public ORAData create(Datum d, int sqlType) throws SQLException
  {
    if (d == null) return null; 
    SaeugetierRef r = new SaeugetierRef();
    r._ref = (REF) d;
    return r;
  }

  public static SaeugetierRef cast(ORAData o) throws SQLException
  {
     if (o == null) return null;
     try { return (SaeugetierRef) getORADataFactory().create(o.toDatum(null), OracleTypes.REF); }
     catch (Exception exn)
     { throw new SQLException("Unable to convert "+o.getClass().getName()+" to SaeugetierRef: "+exn.toString()); }
  }

  public Saeugetier getValue() throws SQLException
  {
     return (Saeugetier) Saeugetier.getORADataFactory().create(
       _ref.getSTRUCT(), OracleTypes.REF);
  }

  public void setValue(Saeugetier c) throws SQLException
  {
    _ref.setValue((STRUCT) c.toDatum(_ref.getJavaSqlConnection()));
  }
}
