#ifndef TIERE_ORACLE
# include "tiere.hpp"
#endif


/*****************************************************************/
//  generated method implementations for the TIER object type.
/*****************************************************************/

OCCI_STD_NAMESPACE::string tier::getName() const
{
  return NAME;
}

void tier::setName(const OCCI_STD_NAMESPACE::string &value)
{
  NAME = value;
}

void *tier::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *tier::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.TIER");
}

void *tier::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *tier::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string tier::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.TIER");
}

void tier::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &tier::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

tier::tier()
{
}

void *tier::readSQL(void *ctxOCCI_)
{
  tier *objOCCI_ = new(ctxOCCI_) tier(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void tier::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   NAME = streamOCCI_.getString();
}

void tier::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  tier *objOCCI_ = (tier *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void tier::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   streamOCCI_.setString(NAME);
}

tier::~tier()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the SAEUGETIER object type.
/*****************************************************************/

oracle::occi::Number saeugetier::getSchulterhoehe() const
{
  return SCHULTERHOEHE;
}

void saeugetier::setSchulterhoehe(const oracle::occi::Number &value)
{
  SCHULTERHOEHE = value;
}

void *saeugetier::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *saeugetier::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.SAEUGETIER");
}

void *saeugetier::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *saeugetier::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string saeugetier::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.SAEUGETIER");
}

void saeugetier::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &saeugetier::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

saeugetier::saeugetier()
{
}

void *saeugetier::readSQL(void *ctxOCCI_)
{
  saeugetier *objOCCI_ = new(ctxOCCI_) saeugetier(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void saeugetier::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   tier::readSQL(streamOCCI_);
   SCHULTERHOEHE = streamOCCI_.getNumber();
}

void saeugetier::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  saeugetier *objOCCI_ = (saeugetier *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void saeugetier::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   tier::writeSQL(streamOCCI_);
   streamOCCI_.setNumber(SCHULTERHOEHE);
}

saeugetier::~saeugetier()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the LOEWE object type.
/*****************************************************************/

void *loewe::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *loewe::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.LOEWE");
}

void *loewe::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *loewe::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string loewe::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.LOEWE");
}

void loewe::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &loewe::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

loewe::loewe()
{
}

void *loewe::readSQL(void *ctxOCCI_)
{
  loewe *objOCCI_ = new(ctxOCCI_) loewe(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void loewe::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   saeugetier::readSQL(streamOCCI_);
}

void loewe::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  loewe *objOCCI_ = (loewe *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void loewe::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   saeugetier::writeSQL(streamOCCI_);
}

loewe::~loewe()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the ELEFANT object type.
/*****************************************************************/

oracle::occi::Number elefant::getRuessellange() const
{
  return RUESSELLANGE;
}

void elefant::setRuessellange(const oracle::occi::Number &value)
{
  RUESSELLANGE = value;
}

void *elefant::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *elefant::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.ELEFANT");
}

void *elefant::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *elefant::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string elefant::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.ELEFANT");
}

void elefant::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &elefant::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

elefant::elefant()
{
}

void *elefant::readSQL(void *ctxOCCI_)
{
  elefant *objOCCI_ = new(ctxOCCI_) elefant(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void elefant::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   saeugetier::readSQL(streamOCCI_);
   RUESSELLANGE = streamOCCI_.getNumber();
}

void elefant::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  elefant *objOCCI_ = (elefant *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void elefant::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   saeugetier::writeSQL(streamOCCI_);
   streamOCCI_.setNumber(RUESSELLANGE);
}

elefant::~elefant()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the VOGEL object type.
/*****************************************************************/

oracle::occi::Number vogel::getSpannweite() const
{
  return SPANNWEITE;
}

void vogel::setSpannweite(const oracle::occi::Number &value)
{
  SPANNWEITE = value;
}

void *vogel::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *vogel::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.VOGEL");
}

void *vogel::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *vogel::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string vogel::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.VOGEL");
}

void vogel::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &vogel::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

vogel::vogel()
{
}

void *vogel::readSQL(void *ctxOCCI_)
{
  vogel *objOCCI_ = new(ctxOCCI_) vogel(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void vogel::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   tier::readSQL(streamOCCI_);
   SPANNWEITE = streamOCCI_.getNumber();
}

void vogel::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  vogel *objOCCI_ = (vogel *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void vogel::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   tier::writeSQL(streamOCCI_);
   streamOCCI_.setNumber(SPANNWEITE);
}

vogel::~vogel()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the ELSTER object type.
/*****************************************************************/

void *elster::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *elster::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.ELSTER");
}

void *elster::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *elster::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string elster::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.ELSTER");
}

void elster::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &elster::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

elster::elster()
{
}

void *elster::readSQL(void *ctxOCCI_)
{
  elster *objOCCI_ = new(ctxOCCI_) elster(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void elster::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   vogel::readSQL(streamOCCI_);
}

void elster::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  elster *objOCCI_ = (elster *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void elster::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   vogel::writeSQL(streamOCCI_);
}

elster::~elster()
{
  int i;
}

/*****************************************************************/
//  generated method implementations for the PFLEGER_T object type.
/*****************************************************************/

OCCI_STD_NAMESPACE::string pfleger_t::getName() const
{
  return NAME;
}

void pfleger_t::setName(const OCCI_STD_NAMESPACE::string &value)
{
  NAME = value;
}

OCCI_STD_NAMESPACE::vector< oracle::occi::Ref< tier > >& pfleger_t::getPflegt() 
{
  return PFLEGT;
}

const OCCI_STD_NAMESPACE::vector< oracle::occi::Ref< tier > >& pfleger_t::getPflegt() const
{
  return PFLEGT;
}

void pfleger_t::setPflegt(const OCCI_STD_NAMESPACE::vector< oracle::occi::Ref< tier > > &value)
{
  PFLEGT = value;
}

void *pfleger_t::operator new(size_t size)
{
  return oracle::occi::PObject::operator new(size);
}

void *pfleger_t::operator new(size_t size, const oracle::occi::Connection * sess,
  const OCCI_STD_NAMESPACE::string& table)
{
  return oracle::occi::PObject::operator new(size, sess, table, 
            (char *) "OBJECT.PFLEGER_T");
}

void *pfleger_t::operator new(size_t size, void *ctxOCCI_)
{
 return oracle::occi::PObject::operator new(size, ctxOCCI_);
}

void *pfleger_t::operator new(size_t size,
    const oracle::occi::Connection *sess,
    const OCCI_STD_NAMESPACE::string &tableName, 
    const OCCI_STD_NAMESPACE::string &typeName,
    const OCCI_STD_NAMESPACE::string &tableSchema, 
    const OCCI_STD_NAMESPACE::string &typeSchema)
{
  return oracle::occi::PObject::operator new(size, sess, tableName,
        typeName, tableSchema, typeSchema);
}

OCCI_STD_NAMESPACE::string pfleger_t::getSQLTypeName() const
{
  return OCCI_STD_NAMESPACE::string("OBJECT.PFLEGER_T");
}

void pfleger_t::getSQLTypeName(oracle::occi::Environment *env, void **schemaName,
    unsigned int &schemaNameLen, void **typeName, unsigned int &typeNameLen) const
{
  PObject::getSQLTypeName(env, &pfleger_t::readSQL, schemaName,
        schemaNameLen, typeName, typeNameLen);
}

pfleger_t::pfleger_t()
{
}

void *pfleger_t::readSQL(void *ctxOCCI_)
{
  pfleger_t *objOCCI_ = new(ctxOCCI_) pfleger_t(ctxOCCI_);
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (streamOCCI_.isNull())
      objOCCI_->setNull();
    else
      objOCCI_->readSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    delete objOCCI_;
    excep.setErrorCtx(ctxOCCI_);
    return (void *)NULL;
  }
  return (void *)objOCCI_;
}

void pfleger_t::readSQL(oracle::occi::AnyData& streamOCCI_)
{
   NAME = streamOCCI_.getString();
   oracle::occi::getVectorOfRefs(streamOCCI_, PFLEGT);
}

void pfleger_t::writeSQL(void *objectOCCI_, void *ctxOCCI_)
{
  pfleger_t *objOCCI_ = (pfleger_t *) objectOCCI_;
  oracle::occi::AnyData streamOCCI_(ctxOCCI_);

  try
  {
    if (objOCCI_->isNull())
      streamOCCI_.setNull();
    else
      objOCCI_->writeSQL(streamOCCI_);
  }
  catch (oracle::occi::SQLException& excep)
  {
    excep.setErrorCtx(ctxOCCI_);
  }
  return;
}

void pfleger_t::writeSQL(oracle::occi::AnyData& streamOCCI_)
{
   streamOCCI_.setString(NAME);
   oracle::occi::setVectorOfRefs(streamOCCI_, PFLEGT);
}

pfleger_t::~pfleger_t()
{
  int i;
}
