/*
 * ZielverzeichnisPanel.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import org.netbeans.spi.wizard.WizardController;

@SuppressWarnings("serial")
public class ZielverzeichnisPanel extends BasePanel {

	public static final String STEP_ID = "Zielverzeichnis_id";
	public static final String DESCRIPTION = "Zielverzeichnis";

	public static final String TF_ZIELVERZEICHNIS = "tfZielverzeichnis";

	private WizardController controller;
	private JTextField tfZielverzeichnis;

	public ZielverzeichnisPanel(final WizardController controller) {
		this.controller = controller;
		add(Utilities.createReadOnlyTextArea("Bitte whlen Sie "
				+ "das Installationsverzeichnis.", false, true),
				BorderLayout.NORTH);
		JPanel p = new JPanel(new BorderLayout(6, 0));
		tfZielverzeichnis = new JTextField();
		tfZielverzeichnis.setName(TF_ZIELVERZEICHNIS);
		tfZielverzeichnis.getDocument().addDocumentListener(
				new DocumentListener() {

					public void changedUpdate(DocumentEvent e) {
						setProblem();
					}

					public void insertUpdate(DocumentEvent e) {
						setProblem();
					}

					public void removeUpdate(DocumentEvent e) {
						setProblem();
					}

				});
		JButton btAuswahl = new JButton("Verzeichnis");
		btAuswahl.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				controller.setBusy(true);
				JFileChooser fc = new JFileChooser();
				fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				if (fc.showOpenDialog(ZielverzeichnisPanel.this) == JFileChooser.APPROVE_OPTION) {
					tfZielverzeichnis.setText(fc.getSelectedFile()
							.getAbsolutePath());
				}
				controller.setBusy(false);
			}
		});
		p.add(tfZielverzeichnis, BorderLayout.CENTER);
		p.add(btAuswahl, BorderLayout.EAST);
		JPanel pp = new JPanel(new BorderLayout());
		pp.add(p, BorderLayout.NORTH);
		add(pp, BorderLayout.CENTER);
		setProblem();
	}

	private void setProblem() {
		controller.setProblem(tfZielverzeichnis.getText().length() > 0 ? null
				: "Bitte geben Sie das Zielverzeichnis an.");
	}
}
