package com.thomaskuenneth.articles.ix.wizard;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class Utilities {

    public static JComponent createReadOnlyTextArea(String text, boolean opaque, boolean hideBorder) {
        JTextArea ta = new JTextArea(text);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setOpaque(opaque);
        ta.setFont(UIManager.getFont("Label.font"));
        JScrollPane sp = new JScrollPane(ta);
        if (hideBorder) {
            sp.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        sp.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        sp.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
        return sp;
    }
}
