/*
 * Paketauswahl.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.awt.BorderLayout;
import java.util.Map;

import javax.swing.Box;
import javax.swing.JCheckBox;

import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

@SuppressWarnings("serial")
public class Paketauswahl extends WizardPage {

	public static final String STEP_ID = "Paketauswahl_id";

	public static final String CB_SCHRIFTEN = "cbSchriften";
	public static final String CB_VORLAGEN = "cbVorlagen";

	public Paketauswahl() {
		super(STEP_ID, getDescription());
		setLayout(new BorderLayout());
		add(Utilities.createReadOnlyTextArea("Bitte whlen Sie "
				+ "aus, welche Pakete Sie installieren mchten", false, true),
				BorderLayout.NORTH);
		Box p = Box.createVerticalBox();
		JCheckBox cbBasis = new JCheckBox("VaporOffice XT-Basispaket", true);
		cbBasis.setEnabled(false);
		JCheckBox cbSchriften = new JCheckBox("zustzliche Schriften");
		cbSchriften.setName(CB_SCHRIFTEN);
		JCheckBox cbVorlagen = new JCheckBox("Vorlagen und Formulare");
		cbVorlagen.setName(CB_VORLAGEN);
		p.add(cbBasis);
		p.add(cbSchriften);
		p.add(cbVorlagen);
		p.createGlue();
		add(p, BorderLayout.CENTER);
	}

	@Override
	public WizardPanelNavResult allowBack(String stepName, Map settings,
			Wizard wizard) {
		settings.remove(InstallationsartPanel.RB_ALLES);
		settings.remove(InstallationsartPanel.RB_AUSWAHL);
		return WizardPanelNavResult.PROCEED;
	}

	public static String getDescription() {
		return "Paketauswahl";
	}
}
