/*
 * InstallerDemoBranchController.java
 * 
 * geschrieben 2008 von Thomas Knneth
 * 
 * Dieser Quelltext ist Bestandteil des Artikels
 * Assistenten in Java - die Wizard API
 */
package com.thomaskuenneth.articles.ix.wizard;

import java.util.Map;

import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardBranchController;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPage.WizardResultProducer;

public class InstallerDemoBranchController extends WizardBranchController {

	/**
	 * Wird bentigt, wenn "Fertig" angeklickt wird.
	 */
	// private static final WizardResultProducer ERGEBNIS = WizardResultProducer.NO_OP;
	private static final WizardResultProducer ERGEBNIS = new InstallerDemoResultProducer();

	/**
	 * Dieser Teil-Wizard reprsentiert den Zweig mit Paketauswahl.
	 */
	private static final Wizard ZWEIG_PAKETAUSWAHL = WizardPage
			.createWizard(new Class[] { Paketauswahl.class,
					Zusammenfassung.class }, ERGEBNIS);

	/**
	 * Dieser Teil-Wizard reprsentiert den Zweig ohne Paketauswahl.
	 */
	private static final Wizard ZWEIG_ZUSAMMENFASSUNG = WizardPage
			.createWizard(new Class[] { Zusammenfassung.class }, ERGEBNIS);

	public InstallerDemoBranchController() {
		super(new StartseitePanelProvider());
	}

	@Override
	protected Wizard getWizardForStep(String step, Map settings) {
		if (InstallationsartPanel.STEP_ID.equals(step)) {
			if (Boolean.TRUE.equals(settings
					.get(InstallationsartPanel.RB_AUSWAHL))) {
				return ZWEIG_PAKETAUSWAHL;
			} else if (Boolean.FALSE.equals(settings
					.get(InstallationsartPanel.RB_AUSWAHL))) {
				return ZWEIG_ZUSAMMENFASSUNG;
			}
		}
		return null;
	}
}
