package sample.ix.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

import sample.ix.Activator;

/**
 * Implementation for the RAP-ImageLoader.
 * 
 */
public class ImageLoader implements IImageLoader {

	/**
	 * Array which holds all files in the specified folder.
	 */
	private File[] fileList;
	/**
	 * current index of the image, initial -1.
	 */
	private int index = -1;

	/**
	 * Custom Constructor, used to load all images from the provided plugin.
	 */
	public ImageLoader() {
		Bundle bundle = Platform.getBundle(Activator.RESOURCES_PLUGIN_ID);

		try {
			URL url = FileLocator.toFileURL(bundle.getEntry("images"));
			File f = new File(url.getFile());
			fileList = f.listFiles();

		} catch (IOException e) {
			System.out.println("Error Loading Images.");
			e.printStackTrace();
		}

	}

/**
 * {@inheritDoc}
 * */
	public Image getNextImage() {
		if (index >= fileList.length - 1) {
			index = 0;
		} else {
			index++;
		}

		return loadImage(fileList[index].getName());
	}

	/**
	 * {@inheritDoc}
	 * */
	public Image getPreviousImage() {

		if (index <= 0) {
			index = fileList.length - 1;
		} else {
			index--;
		}
		return loadImage(fileList[index].getName());

	}

	/**
	 * Helper method to load the images. This method gets called by
	 * getPreviousImage() and getNextImage()-Methods.
	 * 
	 * @param key
	 *            the key under which the image is stored.
	 * @return an image instance
	 */
	private Image loadImage(String key) {
		try {
			Image im = Graphics.getImage(key, new FileInputStream(
					fileList[index]));
			return im;
		} catch (FileNotFoundException fnfex) {
			System.out.println("Error, image " + key + " could not be loaded.");
			fnfex.printStackTrace();
		}
	
		return null;
	}

}
