package sample.ix.ui;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import sample.ix.ui.views.ContentView;

/**
 * The Main Perspective Factory.
 * */
public class MainPerspectiveFactory implements IPerspectiveFactory {

	/**
	 * The ID of this Perspective.
	 * */
	public static final String ID = "sample.ix.ui.mainPerspective";
	
	/**
	 * Method used to create the initial layout.
	 * @param layout the PageLayoutInstance.
	 * */
	public void createInitialLayout(IPageLayout layout) {
		
		layout.addStandaloneView(ContentView.ID, false, IPageLayout.LEFT, 1.0f, layout.getEditorArea());
		layout.setEditorAreaVisible(false);
	}

}
