/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSStyleRuleImpl
implements CSSStyleRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private SelectorList _selectors = null;
    private CSSStyleDeclaration _style = null;

    public CSSStyleRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, SelectorList selectorList) {
        this._parentStyleSheet = cSSStyleSheetImpl;
        this._parentRule = cSSRule;
        this._selectors = selectorList;
    }

    public short getType() {
        return 1;
    }

    public String getCssText() {
        return this.getSelectorText() + " " + this.getStyle().toString();
    }

    public void setCssText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this._selectors = ((CSSStyleRuleImpl)cSSRule)._selectors;
            this._style = ((CSSStyleRuleImpl)cSSRule)._style;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getSelectorText() {
        return this._selectors.toString();
    }

    public void setSelectorText(String string) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            this._selectors = cSSOMParser.parseSelectors(inputSource);
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    public void setStyle(CSSStyleDeclarationImpl cSSStyleDeclarationImpl) {
        this._style = cSSStyleDeclarationImpl;
    }

    public String toString() {
        return this.getCssText();
    }
}

