/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.engine.xpath.XPathHelper;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import com.gargoylesoftware.htmlunit.Page;
import org.jaxen.JaxenException;
import org.jaxen.XPath;

public class VerifyXPath
extends AbstractVerifyTextStep {
    private String fXpath;

    public VerifyXPath() {
        this.setOptionalText(true);
        this.setOptionalPreviousPage(true);
    }

    public void setText(String text) {
        super.setText(text);
    }

    public String getXpath() {
        return this.fXpath;
    }

    public void setXpath(String xpath) {
        this.fXpath = xpath;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.fXpath, "xpath");
    }

    public void doExecute() throws JaxenException {
        Page currentResponse = this.getContext().getCurrentResponse();
        XPathHelper xpathHelper = this.getContext().getXPathHelper();
        XPath xpath = xpathHelper.getXPath(currentResponse, this.getXpath());
        Object document = xpathHelper.getDocument(currentResponse);
        this.verifyXPath(xpath, document);
    }

    protected boolean isComparingPathAndValue() {
        return this.getText() != null;
    }

    protected void verifyXPath(XPath xpath, Object document) throws JaxenException, StepFailedException {
        if (this.isComparingPathAndValue()) {
            String actualValue = xpath.stringValueOf(document);
            if (!this.verifyText(actualValue)) {
                throw new StepFailedException("Wrong result for xpath >" + this.fXpath + "<", this.getText(), actualValue, this);
            }
        } else {
            Object singleNode = xpath.selectSingleNode(document);
            if (singleNode == null) {
                throw new StepFailedException("xpath test: " + this.fXpath + " matched no nodes", this);
            }
            if (Boolean.FALSE.equals(singleNode)) {
                throw new StepFailedException("xpath test: " + this.fXpath + " evaluates to false", this);
            }
        }
    }
}

