/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.RegExStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.steps.verify.ZFailedLink;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class VerifyLinks
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)VerifyLinks.class);
    private String fBaseHost;
    private int fMaxDepth;
    private String fMaxDepthStr;
    private int fCurrentDepth;
    private boolean fOnsiteonly;
    private String fExcludes;
    private String fIncludes;
    private final Set fFailedVisits = new HashSet();
    private final Set fVisitedUrls = new HashSet();
    private int fValidLinks;
    private boolean fIgnoreForeignJSErrors;

    protected Set getFailedVisits() {
        return this.fFailedVisits;
    }

    public String getDepth() {
        return this.fMaxDepthStr;
    }

    public void setDepth(String depth) {
        this.fMaxDepthStr = depth;
    }

    public void setExcludes(String regex) {
        this.fExcludes = regex;
    }

    public String getExcludes() {
        return this.fExcludes;
    }

    public void setIncludes(String regex) {
        this.fIncludes = regex;
    }

    public String getIncludes() {
        return this.fIncludes;
    }

    public void setOnsiteonly(boolean onsiteonly) {
        this.fOnsiteonly = onsiteonly;
    }

    public void setIgnoreForeignJSErrors(boolean b) {
        this.fIgnoreForeignJSErrors = b;
    }

    public void doExecute() throws SAXException, MalformedURLException {
        this.verifyProperties();
        this.nullResponseCheck();
        Context context = this.getContext();
        HtmlPage htmlPage = context.getCurrentHtmlResponse(this);
        LOG.info((Object)("Examining page with title=" + htmlPage.getTitleText()));
        if (!StringUtils.isEmpty((String)this.getIncludes())) {
            LOG.info((Object)("Only including links which match '" + this.getIncludes() + "'"));
        }
        if (!StringUtils.isEmpty((String)this.getExcludes())) {
            LOG.info((Object)("Excluding links which match '" + this.getExcludes() + "'"));
        }
        this.fBaseHost = htmlPage.getWebResponse().getUrl().getHost();
        WebClient client = context.getWebClient();
        this.checkVisits(client, htmlPage);
        if (!this.fFailedVisits.isEmpty()) {
            throw new StepFailedException(this.fFailedVisits.size() + " broken link(s): " + this.brokenLinksToString(), this);
        }
    }

    protected void addComputedParameters(Map map) {
        map.put("-> valid links", String.valueOf(this.fValidLinks));
    }

    protected void checkVisits(WebClient webClient, HtmlPage response) {
        Set urls = VerifyLinks.getGoodLinks(response);
        RegExStringVerifier verifier = new RegExStringVerifier();
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (this.fVisitedUrls.contains(url)) {
                LOG.debug((Object)("Skipped already visited: " + url));
                ++this.fValidLinks;
                continue;
            }
            if (!StringUtils.isEmpty((String)this.getIncludes()) && !verifier.verifyStrings(this.getIncludes(), url.toString())) {
                LOG.info((Object)("Skipped link as it doesn't match the includes list: " + url));
                continue;
            }
            if (!StringUtils.isEmpty((String)this.getExcludes()) && verifier.verifyStrings(this.getExcludes(), url.toString())) {
                LOG.info((Object)("Skipped link as matched the excludes list: " + url));
                continue;
            }
            this.visit(response, url, webClient);
        }
    }

    protected void visit(HtmlPage referingPage, URL url, WebClient webClient) {
        boolean ignoreJSErrorsOriginal = webClient.isThrowExceptionOnScriptError();
        if (this.fIgnoreForeignJSErrors && this.isForeignHost(url)) {
            LOG.info((Object)("Ignore JS errors (if any) for " + url));
            webClient.setThrowExceptionOnScriptError(false);
        }
        Page response = HtmlUnitBoundary.tryGetPageNoFail(url, webClient);
        webClient.setThrowExceptionOnScriptError(ignoreJSErrorsOriginal);
        this.fVisitedUrls.add(url);
        if (response == null) {
            this.fFailedVisits.add(new ZFailedLink(url, referingPage.getWebResponse().getUrl()));
        } else {
            ++this.fValidLinks;
            if (response instanceof HtmlPage) {
                this.followRecursively((HtmlPage)response, webClient);
            }
        }
    }

    protected void followRecursively(HtmlPage htmlPage, WebClient webClient) {
        LOG.debug((Object)("fMaxDepth = " + this.fMaxDepth));
        if (this.fCurrentDepth < this.fMaxDepth && !this.stopHunting(htmlPage)) {
            ++this.fCurrentDepth;
            this.checkVisits(webClient, htmlPage);
            --this.fCurrentDepth;
        }
    }

    protected String brokenLinksToString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.fFailedVisits.iterator();
        while (iter.hasNext()) {
            ZFailedLink failedLink = (ZFailedLink)iter.next();
            sb.append(failedLink.getFailedUrl()).append(" on ").append(failedLink.getReferingUrl()).append("; ");
        }
        return sb.toString();
    }

    static int getLinkCount(HtmlPage response) {
        return VerifyLinks.getGoodLinks(response).size();
    }

    static Set getGoodLinks(HtmlPage response) {
        LOG.info((Object)("Looking for links in " + response));
        HashSet urls = new HashSet();
        Iterator iter = response.getAnchors().iterator();
        while (iter.hasNext()) {
            VerifyLinks.processLink(response, (HtmlAnchor)iter.next(), urls);
        }
        LOG.info((Object)(urls.size() + " different links found in page " + response.getWebResponse().getUrl()));
        return urls;
    }

    private static void processLink(HtmlPage response, HtmlAnchor link, Set urls) {
        try {
            URL url = response.getFullyQualifiedUrl(link.getHrefAttribute());
            String protocol = url.getProtocol();
            if ("http".equals(protocol) || "https".equals(protocol)) {
                LOG.info((Object)("Adding url to check: " + url));
                urls.add(url);
            } else {
                LOG.info((Object)("Skipped link due to protocol: " + url));
            }
        }
        catch (MalformedURLException e) {
            LOG.info((Object)("Skipped link due to bad url: " + link.getHrefAttribute()));
        }
    }

    protected boolean stopHunting(HtmlPage htmlPage) {
        return this.fOnsiteonly && this.isForeignHost(htmlPage.getWebResponse().getUrl());
    }

    protected boolean isForeignHost(URL url) {
        return !this.fBaseHost.equals(url.getHost());
    }

    protected void verifyProperties() {
        this.fMaxDepth = ConversionUtil.convertToInt(this.getDepth(), 0);
        this.optionalIntegerParamCheck(this.getDepth(), "depth", true);
    }
}

