/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.verify;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.store.StoreCookie;
import com.canoo.webtest.steps.verify.AbstractVerifyTextStep;
import org.apache.commons.httpclient.Cookie;
import org.apache.log4j.Logger;

public class VerifyCookie
extends AbstractVerifyTextStep {
    private static final Logger LOG = Logger.getLogger((Class)VerifyCookie.class);
    private String fName;

    public VerifyCookie() {
        this.setOptionalText(true);
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setText(String text) {
        super.setText(text);
    }

    public void doExecute() {
        Cookie[] cookies = StoreCookie.getCookies(this.getContext());
        LOG.debug((Object)("Found " + cookies.length + " cookie(s)"));
        if (cookies.length == 0) {
            throw new StepFailedException("No cookie available!", this);
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().equals(this.getName())) continue;
            if (this.getText() == null) {
                return;
            }
            if (this.verifyText(cookie.getValue())) {
                return;
            }
            throw new StepFailedException("Wrong cookie \"" + this.getName() + "\" value found!", this.getText(), cookie.getValue(), this);
        }
        throw new StepFailedException("Cookie \"" + this.getName() + "\" not set!", this);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullParamCheck(this.getName(), "name");
        this.nullResponseCheck();
    }
}

