/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.AbstractBrowserAction;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrame;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.xml.sax.SAXException;

public class FollowFrame
extends AbstractBrowserAction {
    private static final Logger LOG = Logger.getLogger((Class)FollowFrame.class);
    private String fName;
    private String fHtmlId;
    private String fRelative;
    private boolean fIsRelative;

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String newName) {
        this.fName = newName;
    }

    public String getRelative() {
        return this.fRelative;
    }

    public void setRelative(String relative) {
        this.fRelative = relative;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.fIsRelative = ConversionUtil.convertToBoolean(this.fRelative, false);
        this.nullResponseCheck();
        if (this.getHtmlId() != null && this.getName() != null) {
            throw new StepExecutionException("\"name\" and \"htmlId\" can't be combined!", this);
        }
        if (this.getName() == null && this.getHtmlId() == null) {
            throw new StepExecutionException("\"name\" or \"htmlId\" must be set!", this);
        }
    }

    protected Page findTarget(Context context) throws JaxenException, IOException, SAXException {
        HtmlPage page = this.fIsRelative ? (HtmlPage)context.getCurrentResponse() : (HtmlPage)context.getCurrentResponse().getEnclosingWindow().getTopWindow().getEnclosedPage();
        WebWindow frameWindow = FollowFrame.getFrame(page, this.fName, this.fHtmlId);
        if (frameWindow == null) {
            throw new StepFailedException(this.getStepLabel() + " Frame not found with name: " + this.fName + " available: " + page.getFrames(), this);
        }
        return frameWindow.getEnclosedPage();
    }

    static WebWindow getFrame(HtmlPage htmlPage, String name, String htmlId) {
        LOG.info((Object)("Looking for frame (name: \"" + name + "\", htmlId: \"" + htmlId + "\") in " + htmlPage.getWebResponse().getUrl()));
        if ("_top".equals(name)) {
            LOG.debug((Object)"Asked for frame with special name \"_top\", returning the top window for the current page");
            return htmlPage.getEnclosingWindow().getTopWindow();
        }
        WebWindow theFrame = htmlId != null ? FollowFrame.getFrameById(htmlPage, htmlId) : FollowFrame.getFrameByName(htmlPage, name);
        if (theFrame != null) {
            return theFrame;
        }
        Iterator iter = htmlPage.getFrames().iterator();
        while (iter.hasNext()) {
            WebWindow elt = (WebWindow)iter.next();
            if (!(elt.getEnclosedPage() instanceof HtmlPage)) continue;
            LOG.debug((Object)("looking at subframes of \"" + elt.getName() + "\": " + elt));
            WebWindow frame = FollowFrame.getFrame((HtmlPage)elt.getEnclosedPage(), name, htmlId);
            if (frame == null) continue;
            return frame;
        }
        LOG.debug((Object)"frame not found");
        return null;
    }

    private static WebWindow getFrameById(HtmlPage htmlPage, String htmlId) {
        LOG.debug((Object)("Looking for element with id \"" + htmlId + "\""));
        try {
            HtmlElement elt = htmlPage.getHtmlElementById(htmlId);
            if (elt instanceof BaseFrame) {
                LOG.debug((Object)"it's the right one");
                return ((BaseFrame)elt).getEnclosedWindow();
            }
        }
        catch (ElementNotFoundException e) {
            LOG.debug((Object)("No element with id \"" + htmlId + "\""));
        }
        return null;
    }

    private static WebWindow getFrameByName(HtmlPage htmlPage, String name) {
        List subFrames = htmlPage.getFrames();
        Iterator iter = subFrames.iterator();
        while (iter.hasNext()) {
            FrameWindow elt = (FrameWindow)iter.next();
            LOG.debug((Object)("looking at frame \"" + elt.getName() + "\": " + elt));
            if (!elt.getName().equals(name)) continue;
            LOG.debug((Object)"it's the right one");
            return elt;
        }
        return null;
    }

    public void doExecute() throws Exception {
        Context context = this.getContext();
        context.saveResponseAsCurrent(this.findTarget(context));
    }

    public void addText(String text) {
        if (this.getName() == null) {
            this.setName(this.getProject().replaceProperties(text));
        }
    }
}

