/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.request.AbstractIdOrLabelTarget;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.xml.sax.SAXException;

public class ClickButton
extends AbstractIdOrLabelTarget {
    private static final Logger LOG = Logger.getLogger((Class)ClickButton.class);
    private static final Set INPUT_BUTTONS_TYPES = new HashSet();
    private String fName;
    private String fFieldIndex;
    private String fX;
    private String fY;

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setFieldIndex(String index) {
        this.fFieldIndex = index;
    }

    public String getFieldIndex() {
        return this.fFieldIndex;
    }

    public void setX(String clickPositionX) {
        this.fX = clickPositionX;
    }

    public String getX() {
        return this.fX;
    }

    public void setY(String clickPositionY) {
        this.fY = clickPositionY;
    }

    public String getY() {
        return this.fY;
    }

    public void setIndex(int index) {
        LOG.warn((Object)"setIndex is deprecated - use setFieldIndex instead");
        this.setFieldIndex(Integer.toString(index));
    }

    protected ClickableElement findClickableElementByAttribute(HtmlPage page) {
        ClickableElement button = null;
        if (this.getContext().getCurrentForm() != null) {
            LOG.debug((Object)"Looking for button in current form");
            button = this.findButton(this.getContext().getCurrentForm());
        }
        if (button == null) {
            button = this.findButtonAllForms(page);
        }
        return button;
    }

    protected Page findTarget() throws JaxenException, IOException, SAXException {
        ClickableElement button = this.findClickableElement(this.getContext().getCurrentHtmlResponse(this));
        if (button == null) {
            throw this.buildNoButtonFoundException();
        }
        LOG.info((Object)("-> findTarget(by " + button.getTagName() + "): name=" + button.getAttributeValue("name") + " value=" + button.getAttributeValue("value")));
        if (this.isImageButton()) {
            LOG.info((Object)("-> findTarget(by " + button.getTagName() + "): name=" + button.getAttributeValue("name") + " value=" + button.getAttributeValue("value")));
            return ((HtmlInput)button).click(Integer.parseInt(this.getX()), Integer.parseInt(this.getY()));
        }
        return button.click();
    }

    private StepFailedException buildNoButtonFoundException() {
        StepFailedException e = new StepFailedException("No button found", this);
        HtmlForm currentForm = this.getContext().getCurrentForm();
        StringBuffer msg = new StringBuffer();
        if (currentForm != null) {
            msg.append("In current form:\n");
            msg.append(this.getButtonsDescription(currentForm));
        }
        Iterator formsIterator = this.getContext().getCurrentHtmlResponse(this).getForms().iterator();
        while (formsIterator.hasNext()) {
            HtmlForm form = (HtmlForm)formsIterator.next();
            if (form == currentForm) continue;
            if (msg.length() != 0) {
                msg.append("\n\n");
            }
            msg.append("In " + form + ":\n");
            msg.append(this.getButtonsDescription(form));
        }
        e.addDetail("available buttons", msg.toString());
        return e;
    }

    private String getButtonsDescription(HtmlForm _form) {
        ArrayList<HtmlElement> buttons = new ArrayList<HtmlElement>();
        Iterator iter = _form.getAllHtmlChildElements();
        while (iter.hasNext()) {
            HtmlElement element = (HtmlElement)iter.next();
            if (element instanceof HtmlInput && ClickButton.isInputButtonType((HtmlInput)element)) {
                buttons.add(element);
                continue;
            }
            if (!(element instanceof HtmlButton)) continue;
            buttons.add(element);
        }
        if (buttons.isEmpty()) {
            return "none";
        }
        return ((Object)buttons).toString();
    }

    protected String getLogMessageForTarget() {
        return "by clickButton with name: " + this.getName();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        this.paramCheck(StringUtils.isEmpty((String)this.getX()) && !StringUtils.isEmpty((String)this.getY()) || !StringUtils.isEmpty((String)this.getX()) && StringUtils.isEmpty((String)this.getY()), "X and Y values must be set for click button support!");
        this.paramCheck(this.getLabel() == null && this.fName == null && this.getHtmlId() == null && this.getXpath() == null, "Required parameter 'label', 'name', 'htmlid' or 'xpath' must be set!");
        this.optionalIntegerParamCheck(this.getFieldIndex(), "fieldIndex", true);
        this.optionalIntegerParamCheck(this.getX(), "x", false);
        this.optionalIntegerParamCheck(this.getY(), "y", false);
    }

    ClickableElement checkFoundElement(HtmlElement elt) throws StepFailedException {
        if (!ClickButton.isButton(elt)) {
            throw new StepFailedException("Selected element is a " + elt.getTagName() + " tag and not a button", this);
        }
        if (this.hasMatchingNameOrDontCare(elt) && this.hasMatchingLabelOrDontCare(elt)) {
            LOG.debug((Object)"Button passes test with label and name");
            return (ClickableElement)elt;
        }
        LOG.debug((Object)("Test with name and label fails for html button: " + elt));
        return null;
    }

    ClickableElement findButton(HtmlForm form) {
        LOG.debug((Object)("Looking for inputs of type submit, image or button in " + form));
        ClickableElement button = this.findInputButton(form);
        if (button != null) {
            return button;
        }
        LOG.debug((Object)("Looking for \"normal\" button in " + form));
        return this.findNormalButton(form);
    }

    private ClickableElement findButtonAllForms(HtmlPage currentResp) {
        LOG.debug((Object)"Looking for button in all forms contained in the document");
        List forms = currentResp.getForms();
        if (forms.size() == 0) {
            LOG.warn((Object)"No forms found - page probably non-compliant - searching page anyway");
            return this.searchButton(currentResp);
        }
        Iterator iter = forms.iterator();
        while (iter.hasNext()) {
            ClickableElement button = this.findButton((HtmlForm)iter.next());
            if (button == null) continue;
            return button;
        }
        return null;
    }

    private static boolean isButton(HtmlElement elt) {
        if (elt instanceof HtmlButton) {
            LOG.debug((Object)"It's a button, that's ok");
            return true;
        }
        if (elt instanceof HtmlInput && ClickButton.isInputButtonType((HtmlInput)elt)) {
            LOG.debug((Object)("It's an " + elt.getAttributeValue("type") + " input, that's ok"));
            return true;
        }
        LOG.debug((Object)"Html element is not a button");
        return false;
    }

    private static boolean isInputButtonType(HtmlInput input) {
        return INPUT_BUTTONS_TYPES.contains(input.getTypeAttribute().toLowerCase());
    }

    private ClickableElement findInputButton(HtmlForm form) {
        List inputButtons = form.getHtmlElementsByTagName("input");
        return this.findInputButton(inputButtons.iterator());
    }

    private ClickableElement searchButton(HtmlPage page) {
        ArrayList<HtmlElement> buttons = new ArrayList<HtmlElement>();
        Iterator childElements = page.getAllHtmlChildElements();
        while (childElements.hasNext()) {
            HtmlElement elt = (HtmlElement)childElements.next();
            if (!ClickButton.isButton(elt)) continue;
            buttons.add(elt);
        }
        ClickableElement button = this.findInputButton(buttons.iterator());
        if (button == null) {
            button = this.findNormalButton(buttons.iterator());
        }
        return button;
    }

    private ClickableElement findInputButton(Iterator candidateIterator) {
        int indexFound = 0;
        while (candidateIterator.hasNext()) {
            HtmlInput curInput;
            HtmlElement curElement = (HtmlElement)candidateIterator.next();
            if (!(curElement instanceof HtmlInput) || !ClickButton.isInputButtonType(curInput = (HtmlInput)curElement)) continue;
            LOG.debug((Object)("Examining button: " + curInput));
            if (!this.hasMatchingNameOrDontCare(curInput) || !this.hasMatchingLabelOrDontCare((HtmlElement)curInput)) continue;
            if (indexFound == ConversionUtil.convertToInt(this.getFieldIndex(), 0)) {
                LOG.debug((Object)(curInput.getTypeAttribute() + " button found: " + curInput));
                return curInput;
            }
            ++indexFound;
        }
        return null;
    }

    private ClickableElement findNormalButton(HtmlForm form) {
        return this.findNormalButton(form.getAllHtmlChildElements());
    }

    private ClickableElement findNormalButton(Iterator candidateIterator) {
        int indexFound = 0;
        while (candidateIterator.hasNext()) {
            HtmlElement curElement = (HtmlElement)candidateIterator.next();
            if (!(curElement instanceof HtmlButton)) continue;
            HtmlButton curButton = (HtmlButton)curElement;
            LOG.debug((Object)("Examining button: " + curButton));
            if (!this.hasMatchingNameOrDontCare(curButton) || !this.hasMatchingLabelOrDontCare((HtmlElement)curButton)) continue;
            if (indexFound == ConversionUtil.convertToInt(this.getFieldIndex(), 0)) {
                LOG.debug((Object)("Normal button found: " + curButton));
                return curButton;
            }
            ++indexFound;
        }
        return null;
    }

    private boolean hasMatchingNameOrDontCare(HtmlElement curButton) {
        if (curButton instanceof HtmlInput) {
            return this.hasMatchingNameOrDontCare((HtmlInput)curButton);
        }
        if (curButton instanceof HtmlButton) {
            return this.hasMatchingNameOrDontCare((HtmlButton)curButton);
        }
        throw new IllegalArgumentException("Button is neither a HtmlInput nor a HtmlButton: " + curButton);
    }

    private boolean hasMatchingNameOrDontCare(HtmlInput curButton) {
        return this.getName() == null || this.getName().equals(curButton.getNameAttribute());
    }

    private boolean hasMatchingNameOrDontCare(HtmlButton curButton) {
        return this.getName() == null || this.getName().equals(curButton.getNameAttribute());
    }

    private boolean hasMatchingLabelOrDontCare(HtmlElement curButton) {
        if (this.getLabel() == null) {
            return true;
        }
        if (curButton instanceof HtmlImageInput) {
            return this.getLabel().equals(((HtmlImageInput)curButton).getAltAttribute());
        }
        return this.getLabel().equals(curButton.asText());
    }

    protected boolean isImageButton() {
        return !StringUtils.isEmpty((String)this.getX()) && !StringUtils.isEmpty((String)this.getY());
    }

    public void addText(String text) {
        this.setLabel(this.getProject().replaceProperties(text));
    }

    static {
        INPUT_BUTTONS_TYPES.add("submit");
        INPUT_BUTTONS_TYPES.add("image");
        INPUT_BUTTONS_TYPES.add("button");
        INPUT_BUTTONS_TYPES.add("reset");
    }
}

