/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.request;

import com.canoo.webtest.boundary.HtmlUnitBoundary;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.request.AbstractTargetAction;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.log4j.Logger;

public abstract class AbstractIdOrLabelTarget
extends AbstractTargetAction {
    private static final Logger LOG = Logger.getLogger((Class)AbstractIdOrLabelTarget.class);
    private String fLabel;
    private String fHtmlId;
    private String fXPath;

    public void setLabel(String newLabel) {
        this.fLabel = newLabel;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setXpath(String xpath) {
        this.fXPath = xpath;
    }

    public String getXpath() {
        return this.fXPath;
    }

    protected ClickableElement findClickableElement(HtmlPage page) {
        if (this.getHtmlId() != null) {
            return this.findClickableElementById(page);
        }
        if (this.getXpath() != null) {
            return this.findClickableElementByXPath(page);
        }
        return this.findClickableElementByAttribute(page);
    }

    protected abstract ClickableElement findClickableElementByAttribute(HtmlPage var1);

    ClickableElement findClickableElementById(HtmlPage page) {
        HtmlElement elt;
        LOG.debug((Object)("Looking for html element with id: " + this.getHtmlId()));
        try {
            elt = page.getHtmlElementById(this.getHtmlId());
        }
        catch (ElementNotFoundException e) {
            LOG.info((Object)("No html element found with id: " + this.getHtmlId()));
            return null;
        }
        return this.checkFoundElement(elt);
    }

    ClickableElement findClickableElementByXPath(HtmlPage page) {
        LOG.debug((Object)("Looking for html element with xpath: " + this.getXpath()));
        Object node = HtmlUnitBoundary.trySelectSingleNodeByXPath(this.getXpath(), (Page)page, this);
        LOG.debug((Object)("XPath evaluates to: " + node));
        if (node == null) {
            return null;
        }
        if (node instanceof HtmlElement) {
            return this.checkFoundElement((HtmlElement)node);
        }
        throw new StepFailedException("The xpath doesn't select an HTML element but a '" + node.getClass() + "'");
    }

    abstract ClickableElement checkFoundElement(HtmlElement var1) throws StepFailedException;
}

