/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.FormUtil;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class SelectForm
extends Step {
    private static final Logger LOG = Logger.getLogger((Class)SelectForm.class);
    private String fIndex;
    private String fName;

    public void doExecute() throws Exception {
        this.nullResponseCheck();
        Context context = this.getContext();
        HtmlPage currentResp = (HtmlPage)context.getCurrentResponse();
        LOG.debug((Object)("Selecting current form in response from " + currentResp.getWebResponse().getUrl()));
        HtmlForm form = this.fName != null ? FormUtil.findFormByName(currentResp, this.fName) : FormUtil.findFormByIndex(currentResp, this.fIndex);
        if (form == null) {
            throw new StepFailedException("Form not found in doc", this);
        }
        context.setCurrentForm(form);
    }

    public void setIndex(String index) {
        this.fIndex = index;
    }

    public String getIndex() {
        return this.fIndex;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(StringUtils.isEmpty((String)this.fName) && StringUtils.isEmpty((String)this.fIndex), "Either \"name\" or \"index\"  must be set");
        this.paramCheck(!StringUtils.isEmpty((String)this.fName) && !StringUtils.isEmpty((String)this.fIndex), "Only one of \"name\" and \"index\"  must be set");
        this.optionalIntegerParamCheck(this.fIndex, "index", false);
    }

    public void addText(String text) {
        this.setName(text);
    }
}

