/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.form;

import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.extension.StoreElementAttribute;
import com.canoo.webtest.steps.AbstractBrowserAction;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.ClickableElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlLabel;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractSetFieldStep
extends AbstractBrowserAction {
    private static final Logger LOG = Logger.getLogger((Class)AbstractSetFieldStep.class);
    public static final String MESSAGE_ARGUMENT_MISSING = "One of 'forLabel', 'htmlId', 'name', or 'xpath' must be set!";
    public static final String MESSAGE_ARGUMENT_REDUNDANT = "Only one of 'forLabel', 'htmlId', 'name', and 'xpath' should be set!";
    private String fName;
    private String fXPath;
    private String fFormName;
    private String fFieldIndex;
    private String fHtmlId;
    private String fForLabel;

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setForLabel(String text) {
        this.fForLabel = text;
    }

    public String getForLabel() {
        return this.fForLabel;
    }

    public String getXpath() {
        return this.fXPath;
    }

    public void setXpath(String xpath) {
        this.fXPath = xpath;
    }

    public void setFormName(String formName) {
        this.fFormName = formName;
    }

    public String getFormName() {
        return this.fFormName;
    }

    public String getHtmlId() {
        return this.fHtmlId;
    }

    public void setHtmlId(String htmlId) {
        this.fHtmlId = htmlId;
    }

    public void setFieldIndex(String index) {
        this.fFieldIndex = index;
    }

    public String getFieldIndex() {
        return this.fFieldIndex;
    }

    public void doExecute() throws SAXException, IOException {
        if (this.fName != null) {
            HtmlForm form = this.findForm();
            if (form == null) {
                throw new StepFailedException("No suitable form found having field named \"" + this.getName() + "\"", this);
            }
            LOG.debug((Object)("Found matching form " + form));
            this.setField(AbstractSetFieldStep.selectField(this.trimFields(this.findFields(form)), this.getFieldIndex(), this));
        } else if (this.getForLabel() != null) {
            this.setField(this.findFieldByLabel(this.getContext().getCurrentHtmlResponse(this), this.getForLabel()));
        } else {
            this.setField(StoreElementAttribute.findElement((Page)this.getContext().getCurrentHtmlResponse(this), this.getHtmlId(), this.getXpath(), LOG, this));
        }
    }

    HtmlElement findFieldByLabel(HtmlPage page, String labelText) {
        LOG.debug((Object)("Searching label tag with text: " + labelText));
        List labels = page.getDocumentHtmlElement().getHtmlElementsByTagName("label");
        LOG.debug((Object)(labels.size() + " found in the page"));
        IStringVerifier verifier = AbstractSetFieldStep.getVerifier(false);
        Iterator iter = labels.iterator();
        while (iter.hasNext()) {
            HtmlLabel label = (HtmlLabel)iter.next();
            if (!verifier.verifyStrings(labelText, label.asText())) continue;
            LOG.debug((Object)("Found label with matching text, examining the associated field: " + label));
            ClickableElement target = label.getReferencedElement();
            if (this.keepField((HtmlElement)target)) {
                LOG.debug((Object)("Found field: " + target));
                return target;
            }
            LOG.debug((Object)("Target doesn't match: " + target));
        }
        throw new StepFailedException("No label found with text \"" + labelText + "\"", this);
    }

    protected abstract void setField(HtmlElement var1) throws IOException;

    protected abstract HtmlForm findForm();

    protected List findFields(HtmlForm form) {
        return form.getInputsByName(this.fName);
    }

    protected List trimFields(List fields) {
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            HtmlElement elt = (HtmlElement)iter.next();
            LOG.debug((Object)("Considering element " + elt));
            if (this.keepField(elt)) continue;
            iter.remove();
        }
        LOG.debug((Object)("Found " + fields.size() + " field(s)"));
        return fields;
    }

    protected boolean keepField(HtmlElement elt) {
        return true;
    }

    public static HtmlElement selectField(List fieldList, String indexStr, Step step) {
        int index;
        if (fieldList.isEmpty()) {
            throw new StepFailedException("No suitable field(s) found", step);
        }
        int numFieldsFound = fieldList.size();
        if (StringUtils.isEmpty((String)indexStr)) {
            LOG.info((Object)("Found " + numFieldsFound + " suitable fields, considering only the first one"));
            index = 0;
        } else {
            index = ConversionUtil.convertToInt(indexStr, 0);
            if (index < 0 || index >= numFieldsFound) {
                throw new StepFailedException("Can't set field with index '" + index + "', valid range is 0.." + (numFieldsFound - 1), step);
            }
        }
        return (HtmlElement)fieldList.get(index);
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.nullResponseCheck();
        int count = 0;
        if (this.fXPath != null) {
            ++count;
        }
        if (this.fName != null) {
            ++count;
        }
        if (this.fHtmlId != null) {
            ++count;
        }
        if (this.getForLabel() != null) {
            ++count;
        }
        this.paramCheck(count == 0, MESSAGE_ARGUMENT_MISSING);
        this.paramCheck(count > 1, MESSAGE_ARGUMENT_REDUNDANT);
        if (this.fName == null) {
            this.paramCheck(this.fFieldIndex != null, "The attribute 'fieldIndex' is only valid with the attribute 'name'.");
        } else {
            this.optionalIntegerParamCheck(this.fFieldIndex, "fieldIndex", false);
        }
    }
}

