/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps.control;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.AbstractStepContainer;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TimedGroupStep
extends AbstractStepContainer {
    private static final Logger LOG = Logger.getLogger((Class)TimedGroupStep.class);
    private String fSeconds;
    private String fMillis;

    public void setMaxSeconds(String seconds) {
        this.fSeconds = seconds;
    }

    public String getMaxSeconds() {
        return this.fSeconds;
    }

    public void setMaxMillis(String milliseconds) {
        this.fMillis = milliseconds;
    }

    public String getMaxMillis() {
        return this.fMillis;
    }

    public void doExecute() throws CloneNotSupportedException {
        this.notifyStarted();
        this.executeContainedSteps();
        this.notifyCompleted();
        long maxElapsedTimeMillis = this.getMaxElapsedMillis();
        LOG.debug((Object)("Max Time Allowed (millis): " + maxElapsedTimeMillis));
        LOG.debug((Object)("Time Taken (millis): " + this.getDuration()));
        if (this.getDuration() > maxElapsedTimeMillis) {
            throw new StepFailedException("Group took " + this.getDuration() + " ms to execute but maximum allowed was " + maxElapsedTimeMillis + " ms", this);
        }
        this.notifySuccess();
    }

    long getMaxElapsedMillis() {
        return StringUtils.isEmpty((String)this.getMaxMillis()) ? Long.parseLong(this.getMaxSeconds()) * 1000L : Long.parseLong(this.getMaxMillis());
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(StringUtils.isEmpty((String)this.getMaxSeconds()) && StringUtils.isEmpty((String)this.getMaxMillis()), "One of 'maxSeconds' or 'maxMillis' must be set.");
        this.paramCheck(!StringUtils.isEmpty((String)this.getMaxSeconds()) && !StringUtils.isEmpty((String)this.getMaxMillis()), "Only one of 'maxSeconds' or 'maxMillis' must be set.");
        this.optionalIntegerParamCheck(this.getMaxSeconds(), "maxSeconds", true);
        this.optionalIntegerParamCheck(this.getMaxMillis(), "maxMillis", true);
    }
}

