/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.security;

import com.canoo.webtest.engine.Configuration;
import com.canoo.webtest.security.AbstractConnectionInitializer;
import com.canoo.webtest.security.ConnectionInitializationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.log4j.Logger;

public class SunJsseBaseConnectionInitializer
extends AbstractConnectionInitializer {
    private static final Logger LOG = Logger.getLogger((Class)SunJsseBaseConnectionInitializer.class);

    public void initializeConnection(Configuration config) throws ConnectionInitializationException {
        LOG.debug((Object)("Using Custom ConnectionInitializer: " + this.getClass().getName()));
        if (SunJsseBaseConnectionInitializer.isProtocolHttps(config)) {
            if (LOG.isDebugEnabled()) {
                System.setProperty("javax.net.debug", "all");
            }
            this.logProtocolConfiguration(config);
            SunJsseBaseConnectionInitializer.installJsseProviderIfRequired("com.sun.net.ssl.internal.ssl.Provider");
            SunJsseBaseConnectionInitializer.setSystemProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
            SunJsseBaseConnectionInitializer.attemptSetSystemProperty(config, "javax.net.ssl.trustStore", "webtest.truststore.file");
            SunJsseBaseConnectionInitializer.attemptSetSystemProperty(config, "javax.net.ssl.trustStorePassword", "webtest.truststore.passphrase");
            this.installTrustAndKeyManager(config);
            this.installHostnameVerifier(config);
        }
    }

    private static void attemptSetSystemProperty(Configuration config, String propertyKey, String propertyName) throws ConnectionInitializationException {
        String property = SunJsseBaseConnectionInitializer.getExternalProperty(config, propertyName);
        if (property == null) {
            throw new ConnectionInitializationException("Property not set: " + propertyName);
        }
        SunJsseBaseConnectionInitializer.setSystemProperty(propertyKey, property);
    }

    protected void installHostnameVerifier(Configuration config) {
        LOG.info((Object)"Installing HostnameVerifier");
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            public boolean verify(String hostname, SSLSession sslSession) {
                LOG.info((Object)("Granting access for " + hostname));
                return true;
            }
        });
    }

    protected void installTrustAndKeyManager(Configuration config) throws ConnectionInitializationException {
        LOG.debug((Object)"No Trust and no Key manager installed.");
    }

    protected void logProtocolConfiguration(Configuration config) {
        SunJsseBaseConnectionInitializer.logProperty(config, "webtest.truststore.file");
        SunJsseBaseConnectionInitializer.logProperty(config, "webtest.truststore.passphrase");
    }
}

