/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.boundary.PackageBoundary;
import com.canoo.webtest.engine.NameValuePair;
import com.canoo.webtest.engine.WebTestException;
import com.canoo.webtest.reporting.ReportCreationException;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.StepResult;
import com.canoo.webtest.steps.HtmlParserMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlResultConverter {
    public static final String ROOT_ELEMENT = "summary";
    public static final String TESTRESULT_ELEMENT = "testresult";
    public static final String RESULTS_ELEMENT = "results";
    public static final String CONFIG_ELEMENT = "config";
    public static final String PARAMETER_ELEMENT = "parameter";
    public static final String STEP_ELEMENT = "step";
    public static final String FAILURE_ELEMENT = "failure";
    public static final String ERROR_ELEMENT = "error";
    public static final String STEP_RESULT_ATTRIBUTE = "result";
    public static final String STEP_COMPLETED_ELEMENT = "completed";
    public static final String STEP_FAILED_ELEMENT = "failed";
    public static final String STEP_NOTEXECUTED_ELEMENT = "notexecuted";
    private RootStepResult fResult;

    public XmlResultConverter(RootStepResult result) {
        this.fResult = result;
    }

    public void addToDocument(Document doc) throws ReportCreationException {
        Element rootElement;
        NodeList nodeList = doc.getElementsByTagName(ROOT_ELEMENT);
        if (nodeList.getLength() == 0) {
            if (doc.getChildNodes().getLength() > 0) {
                throw new ReportCreationException("Another root already exists!");
            }
            rootElement = doc.createElement(ROOT_ELEMENT);
            doc.appendChild(rootElement);
            this.addSummaryAttribute(rootElement);
        } else {
            rootElement = (Element)nodeList.item(0);
        }
        Element testResult = XmlResultConverter.addNewElement(rootElement, TESTRESULT_ELEMENT);
        this.addResultAttributes(testResult);
        String description = this.fResult.getWebtestDescription();
        if (!StringUtils.isEmpty((String)description)) {
            Element descriptionElt = XmlResultConverter.addNewElement(testResult, "description");
            XmlResultConverter.addText(descriptionElt, description);
        }
        this.addConfig(testResult);
        this.addResults(testResult);
    }

    private void addSummaryAttribute(Element rootElement) {
        XmlResultConverter.addNewAttribute(rootElement, "Implementation-Title", PackageBoundary.getImplementationTitle());
        XmlResultConverter.addNewAttribute(rootElement, "Implementation-Version", PackageBoundary.getImplementationVersion());
    }

    private void addResults(Element parent) {
        Element resultsElement = XmlResultConverter.addNewElement(parent, RESULTS_ELEMENT);
        this.addSteps(resultsElement, this.fResult.getChildren());
        this.addFailureIfNeeded(resultsElement);
        this.addErrorIfNeeded(resultsElement);
    }

    private void addErrorIfNeeded(Element parent) {
        if (this.fResult.isError()) {
            Element errorElement = XmlResultConverter.addNewElement(parent, ERROR_ELEMENT);
            Throwable error = this.fResult.getException();
            XmlResultConverter.addNewAttribute(errorElement, "exception", error.getClass().getName());
            this.addFailureDetails(errorElement);
            Element stackTrace = XmlResultConverter.addNewElement(errorElement, "stacktrace");
            StringWriter s = new StringWriter();
            error.printStackTrace(new PrintWriter(s));
            XmlResultConverter.addText(stackTrace, s.toString());
        }
    }

    private void addFailureIfNeeded(Element parent) {
        if (this.fResult.isFailure()) {
            Element failureElement = XmlResultConverter.addNewElement(parent, FAILURE_ELEMENT);
            this.addFailureDetails(failureElement);
        }
    }

    private void addFailureDetails(Element failure) {
        Throwable throwable = this.fResult.getException();
        ArrayList<Location> locations = new ArrayList<Location>();
        Throwable rootCause = throwable;
        for (Throwable ex = throwable; ex != null; ex = ex.getCause()) {
            rootCause = ex;
            if (!(rootCause instanceof BuildException)) continue;
            locations.add(((BuildException)rootCause).getLocation());
        }
        if (!locations.isEmpty()) {
            Element antCallStack = XmlResultConverter.addNewElement(failure, "antStack");
            for (int i = locations.size() - 1; i >= 0; --i) {
                Location loc = (Location)locations.get(i);
                Element antCall = XmlResultConverter.addNewElement(antCallStack, "call");
                antCall.setAttribute("filename", loc.getFileName());
                antCall.setAttribute("line", String.valueOf(loc.getLineNumber()));
            }
        }
        if (rootCause instanceof WebTestException) {
            WebTestException e = (WebTestException)((Object)rootCause);
            XmlResultConverter.addNewAttribute(failure, "message", e.getShortMessage());
            Iterator iter = e.getDetails().iterator();
            while (iter.hasNext()) {
                NameValuePair detail = (NameValuePair)iter.next();
                Element detailElt = XmlResultConverter.addNewElement(failure, "detail");
                XmlResultConverter.addNewAttribute(detailElt, "name", detail.getName());
                XmlResultConverter.addText(detailElt, detail.getValue());
            }
        } else {
            XmlResultConverter.addNewAttribute(failure, "message", throwable.getMessage());
        }
    }

    private void addSteps(Element parent, List steps) {
        Iterator iter = steps.iterator();
        while (iter.hasNext()) {
            this.addSingleTask(parent, (StepResult)iter.next());
        }
    }

    private void addSingleTask(Element parent, StepResult stepResult) {
        Element stepElement = XmlResultConverter.addNewElement(parent, STEP_ELEMENT);
        stepElement.setAttribute("taskName", stepResult.getTaskName());
        if (stepResult.getTaskDescription() != null) {
            stepElement.setAttribute("description", stepResult.getTaskDescription());
        }
        XmlResultConverter.addStepResult(stepElement, stepResult);
        TreeMap attributes = new TreeMap(stepResult.getAttributes());
        attributes.remove("description");
        String resultFile = (String)attributes.remove("resultFilename");
        this.addParameters(stepElement, attributes);
        if (resultFile != null) {
            Element resultFileElement = XmlResultConverter.addNewElement(stepElement, "resultFile");
            resultFileElement.setAttribute("name", resultFile);
        }
        if (!stepResult.getHtmlParserMessages().isEmpty()) {
            Element htmlParser = XmlResultConverter.addNewElement(stepElement, "htmlparser");
            XmlResultConverter.addParserMessages(htmlParser, stepResult.getHtmlParserMessages());
        }
        this.addSteps(stepElement, stepResult.getChildren());
    }

    private static void addParserMessages(Element htmlParser, List messages) {
        Iterator iter = messages.iterator();
        while (iter.hasNext()) {
            HtmlParserMessage msg = (HtmlParserMessage)iter.next();
            Element elt = XmlResultConverter.addNewElement(htmlParser, msg.getType().toString());
            elt.setAttribute("url", msg.getURL().toString());
            elt.setAttribute("line", String.valueOf(msg.getLine()));
            elt.setAttribute("col", String.valueOf(msg.getColumn()));
            elt.appendChild(htmlParser.getOwnerDocument().createTextNode(msg.getMessage()));
        }
    }

    private static void addStepResult(Element parent, StepResult step) {
        long duration;
        String result;
        if (step.isCompleted()) {
            result = step.isSuccessful() ? STEP_COMPLETED_ELEMENT : STEP_FAILED_ELEMENT;
            duration = step.getDuration();
        } else {
            result = STEP_NOTEXECUTED_ELEMENT;
            duration = 0L;
        }
        parent.setAttribute(STEP_RESULT_ATTRIBUTE, result);
        parent.setAttribute("duration", Long.toString(duration));
    }

    private void addConfig(Element resultElement) {
        Element configElement = XmlResultConverter.addNewElement(resultElement, CONFIG_ELEMENT);
        this.addParameters(configElement, this.fResult.getConfig().getParameterDictionary());
    }

    private void addParameters(Element parent, Map parameterDictionary) {
        Iterator iter = parameterDictionary.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry parameter = iter.next();
            Element parameterElement = XmlResultConverter.addNewElement(parent, PARAMETER_ELEMENT);
            XmlResultConverter.addNewAttribute(parameterElement, "name", parameter.getKey().toString());
            String value = String.valueOf(parameter.getValue());
            XmlResultConverter.addNewAttribute(parameterElement, "value", value);
        }
    }

    private void addResultAttributes(Element resultElement) {
        XmlResultConverter.addNewAttribute(resultElement, "testspecname", this.fResult.getWebtestName());
        XmlResultConverter.addNewAttribute(resultElement, "location", this.fResult.getWebtestLocation().toString());
        XmlResultConverter.addNewAttribute(resultElement, "starttime", this.fResult.getStartDate().toString());
        if (this.fResult.isCompleted()) {
            XmlResultConverter.addNewAttribute(resultElement, "endtime", this.fResult.getEndDate().toString());
        }
        XmlResultConverter.addNewAttribute(resultElement, "successful", this.fResult.isSuccessful() ? "yes" : "no");
    }

    private static void addNewAttribute(Element parent, String name, String value) {
        parent.setAttribute(name, value);
    }

    private static Element addNewElement(Node parent, String name) {
        Element e = parent.getOwnerDocument().createElement(name);
        parent.appendChild(e);
        return e;
    }

    private static void addText(Node parent, String text) {
        parent.appendChild(parent.getOwnerDocument().createCDATASection(text));
    }
}

