/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.reporting;

import com.canoo.webtest.boundary.PackageBoundary;
import com.canoo.webtest.reporting.IResultReporter;
import com.canoo.webtest.reporting.ReportCreationException;
import com.canoo.webtest.reporting.RootStepResult;
import com.canoo.webtest.reporting.XmlResultConverter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlReporter
implements IResultReporter {
    private static final Logger LOG = Logger.getLogger((Class)XmlReporter.class);
    public static final String ROOT_ELEMENT = "summary";

    protected Document readXmlFile(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        LOG.debug((Object)("Reading file " + file.getPath()));
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(file);
        if (!ROOT_ELEMENT.equals(doc.getFirstChild().getNodeName())) {
            throw new ReportCreationException("Another root already exists: " + doc.getFirstChild().getNodeName() + "!");
        }
        return doc;
    }

    protected void writeXmlFile(Document doc, File outfile) throws Exception {
        LOG.info((Object)("Writing report to " + outfile));
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), this.getEncoding()));
        this.writeXmlFile(doc, writer);
    }

    protected String getEncoding() {
        return "UTF-8";
    }

    protected void writeXmlFile(Document doc, Writer writer) throws IOException {
        OutputFormat format = new OutputFormat(doc);
        format.setIndenting(true);
        format.setEncoding(this.getEncoding());
        format.setLineWidth(100);
        XMLSerializer serializer = new XMLSerializer(writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(doc.getDocumentElement());
        writer.close();
    }

    public void generateReport(RootStepResult result) throws Exception {
        File resultFile = this.getResultFile(result);
        Document doc = this.getDocument(resultFile);
        new XmlResultConverter(result).addToDocument(doc);
        this.writeXmlFile(doc, resultFile);
    }

    protected File getResultFile(RootStepResult result) {
        return result.getConfig().getSummaryFile();
    }

    private Document getDocument(File file) throws Exception {
        if (file.exists()) {
            return this.readXmlFile(file);
        }
        return this.createNewDocument();
    }

    protected Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement(ROOT_ELEMENT);
        doc.appendChild(rootElement);
        this.addSummaryAttribute(rootElement);
        return doc;
    }

    private void addSummaryAttribute(Element element) {
        element.setAttribute("Implementation-Title", PackageBoundary.getImplementationTitle());
        element.setAttribute("Implementation-Version", PackageBoundary.getImplementationVersion());
    }
}

