/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox;

import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PdfBoxPDFPage;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.Predicate;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class PdfBoxPDFField
implements PDFField {
    private final PDField field_;
    private static final Map wrappers_ = new WeakHashMap();

    private PdfBoxPDFField(PDField field) {
        this.field_ = field;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: " + this.getName() + ", ");
        sb.append("value: " + this.getValue());
        return sb.toString();
    }

    public String getValue() {
        try {
            PDField parent = this.field_.getParent();
            PDField field = parent != null ? parent : this.field_;
            String value = field.getValue();
            if (value == null) {
                value = PdfBoxPDFPage.stringValue(field.getDictionary().getDictionaryObject(COSName.DV));
            }
            return value;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read field value", e);
        }
    }

    protected static int getPageNumber(PDField nativeField) {
        int pageNumber = -1;
        try {
            COSDictionary page = (COSDictionary)nativeField.getWidget().getDictionary().getDictionaryObject(COSName.P);
            List pages = nativeField.getAcroForm().getDocument().getDocumentCatalog().getAllPages();
            ListIterator iter = pages.listIterator();
            while (iter.hasNext()) {
                PDPage pageX = (PDPage)iter.next();
                if (!pageX.getCOSDictionary().equals(page)) continue;
                pageNumber = iter.previousIndex();
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed accessing the page", e);
        }
        if (pageNumber == -1) {
            throw new RuntimeException("Failed retrieving page number for field " + nativeField);
        }
        return 1 + pageNumber;
    }

    public PDField getNativeField() {
        return this.field_;
    }

    public boolean isReadOnly() {
        return this.getNativeField().isReadonly();
    }

    public String getName() {
        try {
            return this.getNativeField().getFullyQualifiedName();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem extracting field name", e);
        }
    }

    public static PDFField wrap(PDField nativeField) {
        PDFField wrapperField = (PDFField)wrappers_.get(nativeField);
        if (wrapperField == null) {
            wrapperField = new PdfBoxPDFField(nativeField);
            wrappers_.put(nativeField, wrapperField);
        }
        return wrapperField;
    }

    protected static abstract class FieldPredicate
    implements Predicate {
        protected FieldPredicate() {
        }

        public boolean evaluate(Object object) {
            try {
                return this.evaluateField((PDField)object);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract boolean evaluateField(PDField var1) throws IOException;

        static FieldPredicate buildNamePredicate(String name) {
            return new FieldPredicate(name){
                private final /* synthetic */ String val$name;
                {
                    this.val$name = val$name;
                }

                protected boolean evaluateField(PDField field) throws IOException {
                    PDField parent = field.getParent();
                    String fieldName = parent != null ? parent.getFullyQualifiedName() : field.getFullyQualifiedName();
                    return this.val$name.equals(fieldName);
                }
            };
        }

        static FieldPredicate buildPageNumberPredicate(int pageNumber) {
            return new FieldPredicate(pageNumber){
                private final /* synthetic */ int val$pageNumber;
                {
                    this.val$pageNumber = val$pageNumber;
                }

                protected boolean evaluateField(PDField field) throws IOException {
                    return this.val$pageNumber == PdfBoxPDFField.getPageNumber(field);
                }
            };
        }
    }
}

