/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PdfVerifyNumberOfFieldsStep
extends AbstractVerifyPdfStep {
    private int fCount = -1;
    private int fPage = -1;
    private boolean fIncludeDuplicates;

    public void setCount(int count) {
        this.fCount = count;
    }

    public int getCount() {
        return this.fCount;
    }

    public void setPage(int page) {
        this.fPage = page;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setIncludeDuplicates(boolean includeDuplicates) {
        this.fIncludeDuplicates = includeDuplicates;
    }

    public boolean getIncludeDuplicates() {
        return this.fIncludeDuplicates;
    }

    protected void verifyPdf(PDFPage pdfPage) {
        List fields = -1 == this.getPage() ? pdfPage.getFields() : pdfPage.getFields(this.getPage());
        AbstractCollection fieldNames = this.getIncludeDuplicates() ? new ArrayList() : new HashSet();
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            PDFField field = (PDFField)iter.next();
            fieldNames.add(field.getName());
        }
        if (fieldNames.size() != this.getCount()) {
            throw new StepFailedException(this.buildFailureMessage(), this.getCount(), fieldNames.size());
        }
    }

    protected String buildFailureMessage() {
        StringBuffer sb = new StringBuffer("Wrong number of fields on ");
        if (-1 == this.getPage()) {
            sb.append("all pages ");
        } else {
            sb.append("page " + this.getPage());
        }
        sb.append("(");
        sb.append(this.getIncludeDuplicates() ? "including" : "without");
        sb.append(" duplicates)");
        return sb.toString();
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getCount() == -1, "Required parameter \"count\" not set!");
    }
}

