/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest;

import com.canoo.webtest.engine.IStringVerifier;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.plugins.pdftest.AbstractVerifyPdfStep;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFLink;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PdfVerifyLinkStep
extends AbstractVerifyPdfStep {
    private boolean fRegex;
    private String fLinkText;
    private String fLinkHref;
    private int fPage = -1;

    public void setText(String value) {
        this.fLinkText = value;
    }

    public String getText() {
        return this.fLinkText;
    }

    public void setHref(String value) {
        this.fLinkHref = value;
    }

    public String getHref() {
        return this.fLinkHref;
    }

    public int getPage() {
        return this.fPage;
    }

    public void setPage(int value) {
        this.fPage = value;
    }

    public void setRegex(boolean regex) {
        this.fRegex = regex;
    }

    public boolean getRegex() {
        return this.fRegex;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getText() == null && this.getHref() == null, "One of 'text' or 'href' is required!");
        this.paramCheck(this.getText() != null && this.getHref() != null, "Only one of 'text' and 'href' can be set!");
    }

    protected void verifyPdf(PDFPage pdfPage) {
        IStringVerifier verifier = PdfVerifyLinkStep.getVerifier(this.getRegex());
        String expectedValue = StringUtils.defaultString((String)this.getText(), (String)this.getHref());
        List links = pdfPage.getLinks();
        Iterator iter = links.iterator();
        while (iter.hasNext()) {
            PDFLink element = (PDFLink)iter.next();
            if (!this.verifyLink(element, verifier, expectedValue)) continue;
            return;
        }
        throw new StepFailedException("No link found matching criteria.");
    }

    boolean verifyLink(PDFLink link, IStringVerifier verifier, String expectedValue) {
        if (this.getPage() != -1 && this.getPage() != link.getPage()) {
            return false;
        }
        String actualValue = this.getHref() != null ? link.getHref() : link.getText();
        return verifier.verifyStrings(expectedValue, actualValue);
    }
}

